-- Code from microlith and bit
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local cor = monocle.Entity()

local function summonJade(position)
    jade = celeste.NPC(position)
    getRoom():Add(jade)
    local sprite = celeste.GFX.SpriteBank:Create("jade")
    jade:Add(sprite)
    jade.Sprite = sprite
    sprite:Play("idle")
    jade.IdleAnim = "idle"
    jade.MoveAnim = "walk"
    jade.Maxspeed = 58
    jade.MoveY = true
end

local function moveJade(xVector,yVector)
  coroutine.yield(jade:MoveTo(jade.Position + vector2(xVector, yVector)))
end

function onBegin()
  if not (getFlag("forestSt")) then
      disableMovement()
      setFlag("forestSt", true)
      summonJade(vector2(3800, -592))
      moveJade(0, -16)
      local level = getLevel()
      coroutine.yield(level:ZoomTo(vector2(140, 60), 1.5, 0.5))
      wait(0.5)
      say("SunkenMountain_ForestStart")
      level:add(cor)
      cor:add(monocle.Coroutine(level:ZoomAcross(vector2(160, 90), 1, 0.5)))
      cor:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(3792, -688), 1)))
      say("SunkenMountain_ForestStart2")
      say("SunkenMountain_ForestB")
      jade.Maxspeed = 10000
      jade.Sprite.Scale.X = -1
      enableMovement()
      moveJade(10000, 0)
  end
end


function onEnd(room, wasSkipped)
  setFlag("forestSt", true)
  jade.Visible = false
  enableMovement()
end