-- Code from microlith and bit
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local cor = monocle.Entity()

local function summonJade(position)
    jade = celeste.NPC(position)
    getRoom():Add(jade)
    local sprite = celeste.GFX.SpriteBank:Create("jade")
    jade:Add(sprite)
    jade.Sprite = sprite
    sprite:Play("idle")
    jade.IdleAnim = "idle"
    jade.MoveAnim = "walk"
    jade.Maxspeed = 58
    jade.MoveY = true
end

local function moveJade(xVector,yVector)
  coroutine.yield(jade:MoveTo(jade.Position + vector2(xVector, yVector)))
end

function onBegin()
  disablePause()
  summonJade(vector2(6880, -1208))
  enablePause()
if not (getFlag("campDone")) then
  setFlag("campB", false)
  setFlag("campBGlitcher", false)
  setFlag("campDGlitcher", false)
  disableMovement()
  moveJade(-1, -32)
  local level = getLevel()
  -- Zoom to 40 pixels below the center of the screen
  coroutine.yield(level:ZoomTo(vector2(160, 90), 1.5, 0.5))
  --player.DummyAutoAnimate = false
  say("SunkenMountain_CampCutscene")
  say("SunkenMountain_CampCutsceneB")
  coroutine.yield(level:ZoomAcross(vector2(160, 90), 1, 0.5))
  playSound("event:/new_content/game/10_farewell/glitch_medium");
  setFlag("campB", true)
  setFlag("campBGlitcher", true)
  wait(0.4)
  setFlag("campB", false)
  say("SunkenMountain_CampCutsceneC")
  jade.Maxspeed = 10000
  jade.Sprite.Scale.X = -1
  moveJade(160, 0)
  playSound("event:/new_content/game/10_farewell/glitch_long");
  setFlag("campB", true)
  wait(0.3)
  setFlag("campB", false)
  wait(0.8)
  setFlag("campB", true)
  wait(0.3)
  setFlag("campB", false)
  say("SunkenMountain_CampCutsceneD")
  --level:ZoomBack(3)
  --level:ResetZoom()
  enableMovement()
  playSound("event:/new_content/game/10_farewell/glitch_medium");
  setFlag("campB", true)
  setFlag("campDGlitcher", true)
  wait(0.4)
  setFlag("campB", false)
  setFlag("campDone", true)
  end
end


function onEnd(room, wasSkipped)
jade.Visible = false
  setFlag("campDone", true)
  enableMovement()
end