local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	say("StuffoWOC03_03")
	setFlag("spawn", false)
	setFlag("turn", true)
	say("StuffoWOC03_04")
	playSound("event:/game/06_reflection/badeline_pull_cliffbreak") 
	setFlag("pre_erupt", true)
	playSound("event:/game/06_reflection/badeline_pull_rumble_loop")
	playSound("event:/game/06_reflection/badeline_pull_rumble_loop")
	playMusic ("music_farewell_part01", 0)
	wait(1)
	playSound("event:/game/06_reflection/badeline_pull_cliffbreak") 
	setFlag("pre_erupt_b", true)
	wait(1)
	setFlag("erupt", true)
	setFlag("turn", false)
	setDarkness (1)
	playSound("event:/game/06_reflection/badeline_pull_impact")
	playSound("event:/game/06_reflection/badeline_pull_cliffbreak") 	
	playMusic ("event:/WOC/music/Stuffo_WOC_music_red02", 0)
	wait(0.5)
	setFlag("lava_flash", true)
	wait(3)
	say("StuffoWOC03_05")
	say("StuffoWOC03_06")
	wait(0.5)
	playSound("event:/game/06_reflection/fallblock_boss_impact") 
	setFlag("fade_out", false)
	wait(1)
	
	setFlag("teleport_chase", true)
	enableMovement ()
	
end

function onEnd(room, wasSkipped)
	
	setFlag("fade_out", false)
	setFlag("teleport_chase", true)
	playMusic ("event:/WOC/music/Stuffo_WOC_music_red02", 0)
	playSound("event:/game/06_reflection/badeline_pull_rumble_loop")
	playSound("event:/game/06_reflection/badeline_pull_rumble_loop")
	setFlag("lava_flash", true)
	setFlag("erupt", true)
	enableMovement ()
	
end