local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	setFlag("fade_out", true)
	
	wait(3)
	playSound("event:/game/06_reflection/supersecret_heartappear") 
	wait(1)
	
	setFlag("spawn_portal", true)
	wait(0.8)
	playSound("event:/game/06_reflection/badeline_pull_impact") 
	wait(1.25)
	setFlag("spawn_portal", false)
	setFlag("visible", true)
	setFlag("wht_a", true)
	say("StuffoWOC03_01")
	wait(1)
	setFlag("wht_a", false)
	enableMovement ()
	
end

function onEnd(room, wasSkipped)
	
	enableMovement ()
	setFlag("visible", true)
	setFlag("wht_b", true)
	setFlag("wht_a", false)
	setFlag("fade_out", true)
	
end