local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	zoom_camera(-10,0,1.6,2)
	setFlag("fade_out", true)
	wait(2)
	setFlag("spawn_portal", true)
	wait(2.2)
	setFlag("spawn_portal", false)
	setFlag("visible", true)
	setFlag("wht_a", true)
	say("StuffoWOC02_07")
	wait(1)
	walk(-8)
	say("StuffoWOC02_08")
	say("StuffoWOC02_09")
	setFlag("wht_a", false)
	wait(3)
	setFlag("wht_b", true)
	wait(1)
	say("StuffoWOC02_10")
	zoom_back(1)
	enableMovement ()
	
end

function onEnd(room, wasSkipped)
	
	enableMovement ()
	setFlag("visible", true)
	setFlag("wht_b", true)
	setFlag("wht_a", false)
	setFlag("fade_out", true)
	
end