local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	setFlag("cutscene1", false)
	zoom_camera(0,2,1.3,1)
	setFlag("WHT1", true)
	walk(-8,true)
	say("StuffoWOC01_02")
	setFlag("WHT1", false)
	setFlag("WHT2", true)
	walk(8,true)
	say("StuffoWOC01_03")
	setFlag("WHT2", false)
	zoom_back(1)
	enableMovement()
	
end

function onEnd(room, wasSkipped)
	setFlag("cutscene1", false)
	setFlag("WHT2", false)
	setFlag("WHT1", false)
	enableMovement()
end