local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	setFlag("lock_camera", true)
	setFlag("visible", false)
	playSound("event:/WOC/sfx/Stuffo_WOC_sfx_portal_enter")
	playSound("event:/game/general/wall_break_ice")
	wait(1)
	zoom_camera(0,2,1.5,2.5)
	setFlag("white", true)
	wait(0.5)
	setFlag("end", true)
	wait(4)
	completeArea()
end

function onEnd(room, wasSkipped)
	
	completeArea()
	enableMovement()
	
end