local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	setFlag("exit_portal", false)
	setFlag("visible", false)
	setFlag("WHT", false)
	setFlag("black", false)
	setFlag("WHT_prev", true)
	wait(4)
	playSound("event:/WOC/sfx/Stuffo_WOC_sfx_portal_exit")
	zoom_camera(0,2,1.2,1.4)
	playSound("event:/game/general/wall_break_ice")
	setFlag("exit_portal", true)
	setFlag("WHT_prev", false)
	setFlag("WHT", true)
	wait(2)
	say("StuffoWOC00_01")
	wait(1)
	setFlag("exit_portal", false)
	setFlag("visible", true)
	playSound("event:/char/madeline/campfire_stand")
	wait(1)
	say("StuffoWOC00_02")
	wait(1)
	zoom_back(1)
	wait(1)
	say("StuffoWOC00_03")
	
end

function onEnd(room, wasSkipped)
	
	setFlag("WHT", false)
	setFlag("exit_portal", false)
	setFlag("visible", true)
	setFlag("black", false)
	setFlag("WHT_prev", false)
	enableMovement()
	
end