local function zoom_camera(x_loc,y_loc,zoom,time)
	
	local tile_size = 8
	
	local location = vector2(x_loc*tile_size+160, y_loc*tile_size+80)
	
	coroutine.yield(engine.Scene:ZoomTo(location, zoom, time))
	
end

local function zoom_back(time)
	coroutine.yield(engine.Scene:ZoomBack(time))
end

local x_loc = player.Position.x
local y_loc = player.Position.y
player.ForceCameraUpdate = true

function onBegin(room)

	disableMovement ()
	setFlag("no_skip", true)
	zoom_camera(0,2,1.3,0)
	walk(160,false,0.5)
	jump()
	walk(88,false,0.9)
	jump()
	walk(50,false,0.9)
	jump()
	walk(100,false,1)
	wait(0.5)
	playSound("event:/game/general/wall_break_ice")
	setFlag("portal_1", true)
	walk(8,true,2)
	wait(1.5)
	playSound("event:/game/general/wall_break_ice")
	setFlag("portal_1", false)
	setFlag("portal_2", true)
	walk(16,true,0.5)
	playSound("event:/game/general/wall_break_ice")
	setFlag("portal_2", false)
	setFlag("portal_3", true)
	wait(2)
	playSound("event:/game/general/wall_break_ice")
	playSound("event:/WOC/sfx/Stuffo_WOC_sfx_portal_enter")
	setFlag("portal_3", false)
	setFlag("portal_4", true)
	walk(16,false,0.3)
	walk(16,false,0.2)
	walk(8,false,0.1)
	walk(-8,true,0.1)
	walk(-8,true,0.2)
	walk(-8,true,0.3)
	walk(-8,true,0.4)
	walk(-8,true,0.5)
	walk(-8,true,0.7)
	walk(-8,true,1)
	walk(-8,true,1.5)
	jump()
	walk(-32,true,2)
	setFlag("black", true)
	enableMovement()
	disableMovement ()
	teleportTo(-856+168, -504+88,"02")
	
end

function onEnd(room, wasSkipped)
	
	setFlag("no_skip", false)
	teleportTo(-272, -152,"03")
	setFlag("visible", true)
	enableMovement()
	
end