local fakeTilesHelper = require("helpers.fake_tiles")

local fallingBlock = {}

fallingBlock.name = "Nomaideline/FallingBlockCustom"

fallingBlock.placements = {
    name = "Falling Block (Custom)",
    data = {
		width = 8,
        height = 8,
        tiletype = "3",
        climbFall = true,
        behind = false,
        ActivationDelay = 0,
		MaxFallSpeed = 160,
		Acceleration = 500,
		ShakeTime = 0.2,
		ShakeSFX = "event:/game/general/fallblock_shake",
		FallStartSFX = "",
		ImpactSFX = "event:/game/general/fallblock_impact",
		FallShouldStopShakeSFX = false
    }
}

local fakeTilesSpriteFunction = fakeTilesHelper.getEntitySpriteFunction("tiletype", false)

fallingBlock.sprite = fakeTilesHelper.getEntitySpriteFunction("tiletype", false)
fallingBlock.fieldInformation = fakeTilesHelper.getFieldInformation("tiletype")

function fallingBlock.depth(room, entity)
    return entity.behind and 5000 or 0
end


return fallingBlock
