function onBegin()

    -- Disable movement
    disableMovement()

    -- Set flag to false
    local flag = "Typorium_Motivation_FinalBackground"
    setFlag(flag, false)

    -- Pans camera to the left of the room
    local left = getRoomCoordinates()
    coroutine.yield(celeste.CutsceneEntity.CameraTo(left, 0, monocle.Ease.SineInOut))

    -- Walks one pixel to the right to make the player face right
    walk(5)
    wait(1)

    -- Set the player to dummy state
    player.DummyAutoAnimate = false
    setPlayerState(11, false)

    -- Waits for the text to finish (69s)
    wait(69)

    -- Pans to the right of the room in 10 seconds
    local right = left + vector2(750, 0)
    coroutine.yield(celeste.CutsceneEntity.CameraTo(right, 10, monocle.Ease.SineInOut))

    -- Set flag to true
    setFlag(flag, true)

    -- Waits a few seconds and end level
    wait(10)
    completeArea(false)
    
end


function onEnd(room, wasSkipped)
    enableMovement()
    player.DummyAutoAnimate = true
end


function onEnter(player)
end


function onStay(player)
end


function onLeave(player)
end