local mayaHelperCustomBumper = {}
local utils = require("utils")
mayaHelperCustomBumper.name = "MayaHelper/MayaCustomBumper"
mayaHelperCustomBumper.depth = 0
mayaHelperCustomBumper.nodeLineRenderType = "line"
mayaHelperCustomBumper.nodeLimits = {0, -1}
mayaHelperCustomBumper.texture = "objects/bumper/MayaHelper/customBumper/idle00"
mayaHelperCustomBumper.placements = {
	{
		name = "Maya's Custom Bumper",
		data = {
			conserveMomentum = false, wobble = false, oneTimeUse = false, sprite = "bumper_maya_custom", spriteEvil = "bumper_evil",
			respawnTime = .6, dashCooldown = .2, dashRefill = 1, strengthMultiplier = 1, 
			freezeFrames = .1, gravitySwitch = 0, flag = "", moveFlag = "", flagTime = -1, 
			moveMode = 0, moveSpeed = 300, moveTime = 3,dreamRefill = false, stopTime = 0, 
			LaunchColor = "FF0000", LaunchColor2 = "990000",AmbienceColor = "FF0000", AmbienceColor2 = "990000",
			LoopWhenFinished = true, ConservationLogic = 0, flagState = true, startPoints="", bumperCount=1, bumperUses= 1, 
			LerpType = 0, refillStamina = true, uses = 1,
			hitSound = "event:/game/06_reflection/pinballbumper_hit",
			fireHitSound =  "event:/game/09_core/hotpinball_activate",
			respawnSound = "event:/game/06_reflection/pinballbumper_reset"
		}
	}
}
mayaHelperCustomBumper.fieldInformation = {
    dashRefill = {fieldType = "integer", editable = true},
	bumperUses = {fieldType = "integer", editable = true},
	LaunchColor = {fieldType = "color"},
	LaunchColor2 = {fieldType = "color"},
	AmbienceColor = {fieldType = "color"},
	AmbienceColor2 = {fieldType = "color"},
	uses = {fieldType = "integer", editable = true},
	gravitySwitch = {fieldType = "integer", options = {
		["No Gravity Change"] = 0,
		["Normal"] = 1,
		["Inverted"] = 2,
		["Switch"] = 3
	}, editable = false},
	moveMode = {fieldType = "integer", options = {
		["Timing"] = 0,
		["Speed"] = 1
	}, editable = false},
	LerpType = {fieldType = "integer", options = {
		["None"] = 0,
		["SineInOut"] = 1
	}, editable = false},
	ConservationLogic = {fieldType = "integer", options = {
		["Hyperbolic Scaling"] = 0,
		["Legacy"] = 1,
		["Full Conservation"] = 2
	}, editable = false},
	LaunchColor
	
}

function mayaHelperCustomBumper.selection(room, entity)
    local x,y,w,h = -13,-13,26,26
    return utils.rectangle(entity.x + x, entity.y + y, w, h)
end
mayaHelperCustomBumper.fieldOrder = {"x", "y","sprite", "LaunchColor","LaunchColor2","AmbienceColor","AmbienceColor2",
"strengthMultiplier", "moveMode", "LerpType","moveFlag","stopTime","moveSpeed","moveTime","startpoints","bumperCount","flag","flagTime","gravitySwitch","ConservationLogic"}
return mayaHelperCustomBumper