﻿using Celeste.Mod.Entities;
using Celeste.Mod.Helpers;
using Microsoft.Xna.Framework;
using Monocle;
using MonoMod.Logs;
using System;

namespace Celeste.Mod.VioletHelper
{
    [CustomEntity("VioletHelper/UltraBoostStacker")]
    internal class UltraBoostStacker : Entity
    {
        public UltraBoostStacker() : base()
        {

        }

        double ultraboostcount = 0;
        bool lockcounter = false;

        public override void Update()
        {
            if (SceneAs<Level>()?.Tracker.GetEntity<Player>() is not Player player)
            {
                return;
            }

            if (player.StartedDashing)
            {
                lockcounter = false;
            }

            if (!lockcounter && player.DashDir.X != 0 && player.DashDir.Y > 0)
            {
                ultraboostcount++;
                lockcounter = true;
            }

            if (ultraboostcount > 0 && player.OnGround())
            {
                player.Speed.X *= (float)Math.Pow(1.2, ultraboostcount - 1);
                ultraboostcount = 0;
            }
        }
    }
}

