﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Xna.Framework;
using Celeste.Mod.Entities;
using Monocle;
using System.Runtime.CompilerServices;
using IL.FMOD;
using IL.Celeste.Mod;

namespace Celeste.Mod.VioletHelper
{
    [CustomEntity("VioletHelper/TheoJellyJuggleIndicator")]
    public class TheoJellyJuggleIndicator : Entity
    {
        private static readonly Vector2 renderOffset = new(0, -8);
        private static readonly Color outlineColor = Calc.HexToColor("081e08");
        private static readonly Color draggingColor = Calc.HexToColor("#FFA500");
        private static readonly Color onbeatColor = Calc.HexToColor("#00FF00");
        private static readonly Color rushingColor = Calc.HexToColor("#FF0000");
        private bool isDragging = false;
        private bool isRushing = false;
        private Vector2 renderPos;
        public TheoJellyJuggleIndicator() : base()
        {
            Depth = Depths.Top - 2;
        }
        public override void Update()
        {
            if (SceneAs<Level>()?.Tracker.GetEntity<Player>() is not Player player)
            {
                return;
            }
            if(player.StateMachine.state != 8 && Input.Grab.Pressed && player.Holding != null)
            {
                isRushing = true;
                isDragging = false;
            }
            else if (Input.Grab.Pressed)
            {
                isRushing = false;
                isDragging = true;
                foreach (Holdable component in base.Scene.Tracker.GetComponents<Holdable>())
                {
                    if (component.Check(player))
                    {
                        isRushing = false;
                        isDragging = false;
                    }  
                }
            }
            renderPos = player.TopCenter + renderOffset;
        }

        public override void Render()
        {
            if (isDragging)
            {
                Draw.Circle(renderPos, 2, outlineColor, 2);
                Draw.Rect(renderPos - Vector2.One, 2, 2, draggingColor);
            }
            else if (isRushing)
            {
                Draw.Circle(renderPos, 2, outlineColor, 2);
                Draw.Rect(renderPos - Vector2.One, 2, 2, rushingColor);
            }
            else
            {
                Draw.Circle(renderPos, 2, outlineColor, 2);
                Draw.Rect(renderPos - Vector2.One, 2, 2, onbeatColor);
            }
        }
    }
}
