﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Celeste.Mod.Entities;
using Monocle;

namespace Celeste.Mod.VioletHelper.Entities
{
    [CustomEntity("VioletHelper/ScreenGlideProtection")]
    public class ScreenGlideProtection : Entity
    {
        public ScreenGlideProtection() : base()
        {
           
        }

        float screenRetainedSpeed = 0f;
        float screenSpeedRetentionTimer = 0f;
        bool wasMovingAway = false;
        
        public override void Update()
        {
            if (SceneAs<Level>()?.Tracker.GetEntity<Player>() is not Player player)
            {
                return;
            }

            if(screenSpeedRetentionTimer > 0f)
            {
                screenSpeedRetentionTimer -= Engine.DeltaTime;
            }
            
            if(player.wallSpeedRetentionTimer > 0f)
            {
                screenRetainedSpeed = player.wallSpeedRetained;
                screenSpeedRetentionTimer = player.wallSpeedRetentionTimer;
            }

            if(player.Speed.X == 0f && screenSpeedRetentionTimer > 0f && wasMovingAway)
            {
                player.Speed.X = screenRetainedSpeed;
                screenRetainedSpeed = 0f;
                screenSpeedRetentionTimer = 0f;
                player.wallSpeedRetained = 0f;
                player.wallSpeedRetentionTimer = 0f;
            }

            if(Math.Sign(screenRetainedSpeed * player.Speed.X) == -1)
            {
                wasMovingAway = true;
            }
            else
            {
                wasMovingAway = false;
            }
           
            base.Update();
        }
    }
}
