﻿using Celeste.Mod.Entities;
using Celeste.Mod.Helpers;
using Microsoft.Xna.Framework;
using Monocle;
using MonoMod.Logs;
using System;
using System.Collections.Generic;

namespace Celeste.Mod.VioletHelper.Entities
{
    [CustomEntity("VioletHelper/NRCBIndicatorController")]
    public class NRCBIndicatorController : Entity
    {
        private static readonly Vector2 renderOffset = new(0, -8);
        private static readonly Color outlineColor = Calc.HexToColor("081e08");
        private static readonly Color renderColor = Calc.HexToColor("#FFA500");
        private static readonly Color wallboostColor = Calc.HexToColor("#FF0000.");
        private bool NrcbSuccess = false;
        private bool Wallboosted = false;
        private int WallboostDirection = 0; 

        private Vector2 renderPos;
            
        public NRCBIndicatorController() : base()
        {
            Depth = Depths.Top - 2;
        }

        bool HasNeutralClimbJumped;
        bool HasClimbJumped;
        bool FacingBackwards; 

        public override void Update()       
        {
            if (SceneAs<Level>()?.Tracker.GetEntity<Player>() is not Player player)
            {
                return;
            }

            if (player.wallBoostTimer > 0)
            {
                HasNeutralClimbJumped = true;
            }
            else
            {
                HasNeutralClimbJumped = false;  
            }

            FacingBackwards = Math.Sign(player.Speed.X * (int)player.Facing) == -1;

            HasClimbJumped = (player.WallJumpCheck(1) || player.WallJumpCheck(-1)) && Input.GrabCheck && player.Stamina > 0f && player.Holding == null && Input.Jump.Pressed; 

            if (HasNeutralClimbJumped && FacingBackwards)
                {
                    WallboostDirection = -(int)player.Facing;   
                    NrcbSuccess = true;
                    Wallboosted = false;
                }
            else if (HasClimbJumped)
            {
                NrcbSuccess = false;
                Wallboosted = false;
            }

            bool HasWallboosted = player.wallBoostTimer > 0 && player.moveX == WallboostDirection;

            if (HasWallboosted && NrcbSuccess)
            {
                Wallboosted = true;
                NrcbSuccess = false;
            }
            
                if (NrcbSuccess || Wallboosted)
            {   
                renderPos = player.TopCenter + renderOffset;
            }
        }

        public override void Render()
        {
            if (NrcbSuccess)
            {
                Draw.Circle(renderPos, 2, outlineColor, 2);
                Draw.Rect(renderPos - Vector2.One, 2, 2, renderColor);
            }
            if (Wallboosted)
            {
                Draw.Circle(renderPos, 2, outlineColor, 2);
                Draw.Rect(renderPos - Vector2.One, 2, 2, wallboostColor);
            }
        }
    }
}