﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;

namespace Celeste.Mod.VioletHelper
{
    [CustomEntity("VioletHelper/DownSmuggleTrigger")]
    public class DownSmuggleTrigger : Trigger
    {
        public DownSmuggleTrigger(EntityData data, Vector2 offset) : base(data, offset)
        {

        }

        bool Staying = true;
        float oldspeed = 0;
        bool oldspeedset = false;

        public override void OnEnter(Player player)
        {
            Staying = true;
        }

        public override void OnLeave(Player player)
        {
            Staying = false;
        }

        public override void Update()
        {
            if (SceneAs<Level>()?.Tracker.GetEntity<Player>() is not Player player)
            {
                return;
            }

            if (player.Holding == null)
            {
                oldspeed = player.Speed.Y;
            }

            if (player.StateMachine.state == 8 && player.DashAttacking && player.DashDir.Y == 1 && !oldspeedset)
            {
                oldspeedset = true;
            }

            if (Staying)
            {
                if(player.StateMachine.state == 0 && oldspeedset)
                {
                    player.Speed.Y = oldspeed;
                    oldspeed = 0;
                    oldspeedset = false;
                }
            }

            base.Update();
        }
    }
}
