local vector2 = require("#microsoft.xna.framework.vector2")
local lua_helper = require("#celeste.mod.LuaCutscenes.LuaHelper")
local monocle = require("#monocle")

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function summonGranny(position)
  granny = celeste.NPC(position)
  getRoom():Add(granny)
  local sprite = celeste.GFX.SpriteBank:Create("granny")
  granny:Add(sprite)
  granny.Sprite = sprite
  sprite:Play("idle")
  granny.IdleAnim = "idle"
  granny.MoveAnim = "walk"
  granny.Maxspeed = 46
  granny.MoveY = true
end

local function moveGranny(xVector, yVector)
  coroutine.yield(granny:MoveTo(granny.Position + vector2(xVector, yVector)))
end	

local function grannyWalks()
    wait(0.4)
  moveGranny(-46, 0)
end

local function grannyWalks2()
  moveGranny(0, 0)
end

function onBegin()
local room = getRoom()
local level = getLevel()
summonGranny(vector2(1020, 56))
local luanet = _G.luanet
	player.ForceCameraUpdate = true
    getLevel().SaveQuitDisabled = true
  walkCoroutine = makeCoroutine(grannyWalks)
  cutsceneEntity:Add(walkCoroutine)
  wait(1)
  disableMovement()
  wait(0.8)
  say("wholesome_week_butcherberries_introA")
  walk(-132)
  wait(0.2)
      player.DummyAutoAnimate = false
	  player.Sprite:Play("duck", true)
  wait(0.8)
  say("wholesome_week_butcherberries_introB")
  	player.ForceCameraUpdate = false
  coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(95, -15), 3))
  say("wholesome_week_butcherberries_introC")
        player.DummyAutoAnimate = true
  coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(687, -58), 1))
    wait(1)
  	player.ForceCameraUpdate = true
  say("wholesome_week_butcherberries_introD")
    end
	
	function onEnd(room, wasSkipped)
	if wasSkipped then
        getLevel().SaveQuitDisabled = false
		player.ForceCameraUpdate = true
        enableMovement()
end
    enableMovement()
    getLevel().SaveQuitDisabled = false
end