
FlagControl={}

--Get your flag table from a file
---@param Filename string Custom flag file that will be opened,you should follow the format:{YourModName}/{SomeExtraFile}../{YourFileName},example:"MyMod/MyLuaFile/MyLua"
---@return table FlagData  A table containing all your flags
function GetWorldFlagTable(Filename)
    --Do type check
    if(type(Filename)~="string")then
        error("This is not a string,please input appropriate filename(string)!!!")    
    end
    --Get data
    WorldFlagLoader,LoaderMessage=loadfile("Mods/"..Filename,"t")
    --Whether the file exists?
    if(LoaderMessage~=nil)then
        error("Couldn't find file "..Filename..",please check it!!!")
    end
    --Whether the data is a table?
    local tmpData=WorldFlagLoader()
    if(type(tmpData)~="table")then
        error("File "..Filename.." dosen't store table data,please check it!!!")
    end
    --OK,return a table containing some flags.
    return tmpData
end

--Adjust flags from flag file,this operation will override your flag file
---@param Filename string Custom flag file that will be opened,you should follow the format:{YourModName}/{SomeExtraFile}../{YourFileName},example:"MyMod/MyLuaFile/MyLua"
---@param flag string Which flag should be adjusted,this param should be a string, if you pass a flag not in the flag file,that means add this flag into the flag file
---@param value any New value for your flag,if this value is a nil ,that means you will delete this flag
---@return nil
function SetWorldFlag(Filename,flag,value)
    --Get table using Filename
    local tmpData=GetWorldFlagTable(Filename)
    --Get specific flag
    if(type(flag)~="string")then
        error("Flag is not a string")
    end
    tmpData[flag]=value
    --Update all values
    local tmpString="return{ "
    for flagname,flagvalue in pairs(tmpData)do
        tmpString=tmpString..flagname.."="..tostring(flagvalue)..","
    end
    tmpString=tmpString.." }"
    local tmpFile=io.open("Mods/"..Filename,'w+')
    --Write back
    io.output(tmpFile)
    io.write(tmpString)
    io.close(tmpFile)
end

--Set all your flags false(even the value is not a bool),this operation will override your flag file
---@param Filename string Custom flag file that will be opened,you should follow the format:{YourModName}/{SomeExtraFile}../{YourFileName},example:"MyMod/MyLuaFile/MyLua"
---@return nil
function InitAllWorldFlag(Filename)
    --Get table using Filename
    local tmpData=GetWorldFlagTable(Filename)
    for flagname,flagvalue in pairs(tmpData)do
        tmpData[flagname]=false
    end
    --Update all values
    local tmpString="return{ "
    for flagname,flagvalue in pairs(tmpData)do
        tmpString=tmpString..flagname.."="..tostring(flagvalue)..","
    end
    tmpString=tmpString.." }"
    local tmpFile=io.open("Mods/"..Filename,'w+')
     --Write back
    io.output(tmpFile)
    io.write(tmpString)
    io.close(tmpFile)
end

---Create a flag file and return {},if the flag file have already existed,this operation will do nothing but return an existing flag table
---@param Filename string Custom Filename,you should follow the format:{YourModName}/{SomeExtraFile}../{YourFileName},example:"MyMod/MyLuaFile/MyLua"
---@return table data If the file has already existed,return the existing flag table,otherwise return {}
function CreateFlagTable(Filename)
    --Do type check
    if(type(Filename)~="string")then
        error("This is not a string,please input appropriate filename(string)!!!")    
    end
    --Get table using Filename
    local WorldFlagLoader,LoaderMessage=loadfile("Mods/"..Filename)
    -- if the table has already existed,do nothing
    if(LoaderMessage==nil)then
        return GetWorldFlagTable(Filename)
    end
    --otherwise,create a new file
    local tmpFile=io.open("Mods/"..Filename,"w")
    local tmpData="return{}"
    io.output(tmpFile)
    io.write(tmpData)
    io.close(tmpFile)
    --return an empty table
    return {}
end

---Reset an empty table for a flag file,this operation will override your flag file and delete all your existing flags,please use it cautiously
---@param Filename string Custom Filename,you should follow the format:{YourModName}/{SomeExtraFile}../{YourFileName},example:"MyMod/MyLuaFile/MyLua"
---@return nil
function ClearFlagTable(Filename)
    --Do type check
    if(type(Filename)~="string")then
        error("This is not a string,please input appropriate filename(string)!!!")    
    end
    --Get table using Filename
    local WorldFlagLoader,LoaderMessage=loadfile("Mods/"..Filename)
    --if the table doesn't exist
    if(LoaderMessage~=nil)then
        error("Couldn't find file "..Filename..",please check it!!!")
    end
    --otherwise set it as an empty table
    local tmpFile=io.open("Mods/"..Filename,"w")
    local tmpData="return{}"
    io.output(tmpFile)
    io.write(tmpData)
    io.close(tmpFile)
end


--Package
FlagControl["GetWorldFlagTable"]=GetWorldFlagTable
FlagControl["SetWorldFlag"]=SetWorldFlag
FlagControl["InitAllWorldFlag"]=InitAllWorldFlag
FlagControl["CreateFlagTable"]=CreateFlagTable
FlagControl["ClearFlagTable"]=ClearFlagTable

return FlagControl
