local badeline = nil

local function badeline_appears(left_side)
  -- determine the position and flipping properties
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 12

  -- create and add a new badeline dummy entity
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  -- play sound + effect
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  -- wait until the next frame so all that can take effect properly
  wait()
end

local function badeline_vanishes()
  -- tell the badeline entity to disappear
  badeline:Vanish()
  celeste.Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  -- clear the stored variable so the memory can be used for something else
  badeline = nil

  -- wait until the next frame
  wait()
end

function onBegin()
	setInventory("Default")
	player.Dashes = 1
	local level = getLevel()
	disableMovement()
	player.ForceCameraUpdate = true
	walkTo(1152, false, 1, true)
	wait(.3)
	coroutine.yield(level:ZoomTo(vector2(155, 120), 2, .75))
	say("PlayerOne_X_ForGranny_1_SevereSnowfall_MEETTHEO_A")
	badeline_appears()
	wait(.5)
	say("PlayerOne_X_ForGranny_1_SevereSnowfall_MEETTHEO_B")
	wait(2)
	say("PlayerOne_X_ForGranny_1_SevereSnowfall_MEETTHEO_C")
	badeline_vanishes()
	coroutine.yield(level:ZoomBack(1))
end

function onEnd()
	if badeline then
		badeline:RemoveSelf()
		badeline = nil
	end
	setInventory("CH6End")
	enableMovement()
	player.ForceCameraUpdate = false
end