local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
    if not getFlag("talkWatched") then
        local level = getLevel()
        local luanet = _G.luanet
        local return_pos = getLevel().Camera.Position
        level:add(coroutineEntity)
        vector = player.Position + vector2(0, 0)
        player.ForceCameraUpdate = true
        disableMovement()

        setFlag("cutscene_camera", true)
        player.Sprite:Play("walk")
        coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(player.Position.X + 100, false, 0.5)))

        badeline = celeste.BadelineDummy(vector2(15744, -1472))
        badeline.Floatness = 0
        level:Add(badeline)
        badeline.Sprite:Play("idle")
        badeline.Sprite.Scale = vector2(1, 1)

        wait(2.0)
        coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 90), 1.5, 3.0)))
        wait(4.0)
        say("SSC2024_maddyendingA")        -- change SSC2024_fonda_salem05 to whatever your dialog id is for this cutscene
        wait(0.5)
		badeline.Sprite.Scale = vector2(-1, 1)
		say("SSC2024_maddyendingB")
		coroutine.yield(badeline:WalkTo(badeline.X - 40))
		say("SSC2024_maddyendingB2")
		wait(1.2)
		say("SSC2024_maddyendingB3")
        player.Sprite:Play("walk")
        coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(player.Position.X + 150, false, 1.5)))
		wait(1)
		badeline.Sprite.Scale = vector2(1, 1)
		coroutine.yield(badeline:WalkTo(badeline.X + 20))
		wait(2)
		say("SSC2024_maddyendingC")
		wait(0.5)
		player.Facing = getEnum("Celeste.Facings", "Left")
        coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(140, 100), 2.0, 1.0)))
        say("SSC2024_maddyendingD")        -- change SSC2024_fonda_salem05 to whatever your dialog id is for this cutscene (needs to be different from the first one ofc)
        walk(10, false, 0.5)
		say("SSC2024_maddyendingE")
        coroutine.yield(level:ZoomBack(2.0))
		say("SSC2024_maddyendingF")
        player.ForceCameraUpdate = true
        player.DummyAutoAnimate = true
        setFlag("cutscene_camera", false)
        enableMovement()
        setFlag("talkWatched", true)        -- remove this line if you wanna test the cutscene repeatedly
    end
end

function onEnd(room, wasSkipped)
    getLevel():remove(coroutineEntity)
    if wasSkipped then
        player.ForceCameraUpdate = true
        player.DummyAutoAnimate = true
        player.Position = vector2(15720,-1472)            -- where madeline should go after skipping cutscene, these are the only coordinates that need changing
        if not badeline then
            local level = getLevel()
            badeline = celeste.BadelineDummy(player.Position - vector2(56, 0))
            badeline.Floatness = 0
            level:Add(badeline)
            badeline.Sprite:Play("idle")
            badeline.Sprite.Scale = vector2(1, 1)
        end
        if badeline then
            badeline.Sprite.Scale = vector2(1, 1)
        end
        enableMovement()
        setFlag("talkWatched", true)
        setFlag("cutscene_camera", false)
    end
end