local Audio = require("#celeste.audio")

function playSprite(sprite, duration)
    player.DummyAutoAnimate = false
    player.Sprite:Play(sprite, false, false)
    if (duration) then
      wait(duration)
      player.DummyAutoAnimate = true
    end
end


function onBegin()
  
  player.Facing = getEnum("Celeste.Facings", "Right")
  setFlag("flag_instantTeleport", false)
  --setup
  player.ForceCameraUpdate=true
  setPlayerState(11)
  disableMovement()
  walkTo(160, false, 1, false)
  --initiate moon changing
  setMusicProgression(3.0)
  wait(0.8)
  setFlag("flag_moonPhase", true)
  wait(2.9)

  --moon full, glows
  setFlag("flag_moonGlow", true)
  wait(0.5)
  setMusicProgression(4.0)
  wait(4.9)

  setFlag("flag_fireEye", true)
  wait(0.4637)

  --Orobouros Eye lights
  setMusicProgression(5.0)
  wait(0.10)
  setFlag("flag_fireEye02", true)
  wait(0.07)
  playSound("event:/saltedsalmon_reversion/saltedsalmon_reversion_fireEye")
  
  
  wait(1.1)

  --candles light
  
  
  wait(1)
  setMusicProgression(6.0)
  wait(1)
  playSound("event:/saltedsalmon_reversion/saltedsalmon_reversion_candle_light")
  setFlag("flag_candle_01", true)
  wait(0.144)
  setFlag("flag_candle_02", true)
  wait(0.144)
  setFlag("flag_candle_03", true)
  wait(0.144)
  setFlag("flag_candle_04", true)
  wait(0.144)
  setFlag("flag_candle_05", true)
  wait(0.144)
  setFlag("flag_candle_06", true)
  wait(0.144)
  setFlag("flag_candle_07", true)
  wait(0.144)
  setFlag("flag_candle_08", true)
  wait(0.144)
  setFlag("flag_candle_09", true)
  wait(0.144)
  setFlag("flag_candle_10", true)
  wait(0.144)
  setFlag("flag_candle_11", true)
  wait(0.144)
  setFlag("flag_candle_12", true)
  wait(0.144)
  setFlag("flag_candle_13", true)
  wait(2.2)

  --cracks appear
  setMusicProgression(7.0)
  
  setFlag("flag_doCracks", true)
  playSound("event:/saltedsalmon_reversion/saltedsalmon_reversion_rockcracks")
  
  wait(2)

  setFlag("flag_doCracks_2", true)
  playSound("event:/saltedsalmon_reversion/saltedsalmon_reversion_rockcracks")
  
  wait(2)

  setFlag("flag_doCracks_3", true)
  playSound("event:/saltedsalmon_reversion/saltedsalmon_reversion_rockcracks")
  
  wait(2.21)

  --slight pause
  getRoom().Session.Audio.AmbienceVolume = 0
  Audio.CurrentAmbienceEventInstance:setVolume(0)
  setMusicProgression(8.0)
  wait(0.26)
  setFlag("flag_fireEye", false)
  setFlag("flag_fireEye02", false)
  setFlag("flag_blackoff", false)
  setFlag("flag_blackCover", true)
  wait(1.2)
  --colorgrade black+white, trigger fall 
  
  
  setPlayerState(0)
  setFlag("flag_changeSpotLight", true)
  setPlayerState(11)
  setFlag("flag_turnOffTarget", true)
  

  setFlag("flag_doCracks", false)
  setFlag("flag_doCracks_2", false)
  setFlag("flag_doCracks_3", false)

  setFlag("flag_cameraDownFall", true)

  setFlag("flag_slowDown", true)

  setFlag("flag_blackwhite", true)
  

  setFlag("flag_setFallSpeed", true)

  setFlag("flag_fallBlockOff", true)

  setFlag("flag_blackoff", true)
  

  setFlag("flag_vignette", true)

  setFlag("flag_setDarknessAlpha", true)

  getRoom().Session.Audio.AmbienceVolume = 0
  Audio.CurrentAmbienceEventInstance:setVolume(0)

  playSound("event:/saltedsalmon_reversion/saltedsalmon_reversion_fall_impact")
  setFlag("flag_doParticles", true)
  coroutine.yield(engine.Scene:ZoomTo(vector2(165, 120), 1.5, 0))
  playSprite("bigfall", 0.72)
  setFlag("flag_revertColorGrade", true)
  setFlag("flag_blackoff", false)
  
  setPlayerState(0)
  setFlag("flag_instantTeleport", false)
  instantTeleportTo(1616,-2081,"ending")
    
end

function onEnd(room, wasSkipped)
  setPlayerState(0)
  setFlag("flag_blackoff", false)
  if wasSkipped then 
      
      setPlayerState(0)
      
      enableMovement()
      
      setFlag("flag_instantTeleport", true)
      
      end

  setPlayerState(0)
  enableMovement()
  
  
end