local vector2 = require("#microsoft.xna.framework.vector2")

local function fromRoom(x,y)
    return engine.Scene.LevelOffset + vector2(x, y)
end

local jeremyNPC = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("jeremy")

function onBegin()
  if not getFlag("jeremyMoved") and getFlag("decal_flag") then
    setFlag("jeremyMoved", true)
    disableMovement()
    waitUntilOnGround()
    wait(3)
    jeremyNPC:PlayAnimation("idle")
    wait(2.5)
    jeremyNPC:PlayAnimation("walk")
    coroutine.yield(jeremyNPC:MoveTo(fromRoom(228,152)))
  end
end

function onEnd(level, wasSkipped)
  enableMovement()
end