local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local badeline = nil

local function badeline_appears(left_side)
  -- determine the position and flipping properties
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 8

  -- create and add a new badeline dummy entity
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  -- play sound + effect
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  -- wait until the next frame so all that can take effect properly
  wait()
end

local function badeline_vanishes()
  -- tell the badeline entity to disappear
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  -- clear the stored variable so the memory can be used for something else
  badeline = nil

  -- wait until the next frame
  wait()
end

function onBegin()
	local level = getLevel()
	local luanet = _G.luanet
    if (getFlag("moladan_intro_run")) then
        do return end
    end

    disableMovement()
    coroutine.yield(getLevel():ZoomTo(vector2(200, 100), 2, 1))

    badeline_appears(true)
	say("ss2024_moladan_intro_1")

    jump()
    walk(60)

    say("ss2024_moladan_intro_2")

    badeline_vanishes()
	coroutine.yield(getLevel():ZoomBack(1))
    enableMovement()
end

function onEnd(room, wasSkipped)
  getLevel():resetZoom()
  if badeline then
    badeline:RemoveSelf()
    badeline = nil
  end
  enableMovement()
    setFlag("moladan_intro_run", true)
end
