local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

-- Does a dialog choice with 4 dialog keys as the options
local function normal_choice(a, b, c, d)
    local result = choice(a, b, c, d)
    if result == 1 then
        say(a .. "_SAY")
    elseif result == 2 then
        say(b .. "_SAY")
    elseif result == 3 then
        say(c .. "_SAY")
    else
        say(d .. "_SAY")
    end
end

function onBegin()
	local level = getLevel()
	local luanet = _G.luanet
    if (getFlag("moladan_court_run")) then
        do return end
    end

	disableMovement()

    say("ss2024_moladan_court_1")
	coroutine.yield(getLevel():ZoomTo(vector2(285, 120), 2, 1))
    say("ss2024_moladan_court_1a")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 4, 1))
    say("ss2024_moladan_court_1b")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 6, 1))
    say("ss2024_moladan_court_1c")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 8, 1))
    say("ss2024_moladan_court_1d")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 10, 1))
    say("ss2024_moladan_court_1e")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 12, 1))
    say("ss2024_moladan_court_1f")
	coroutine.yield(getLevel():ZoomBack(1))

    say("ss2024_moladan_court_2")
	coroutine.yield(getLevel():ZoomTo(vector2(285, 120), 16, 1))
    say("ss2024_moladan_court_2a")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 20, 1))
    say("ss2024_moladan_court_2b")
	coroutine.yield(getLevel():ZoomAcross(vector2(285, 120), 24, 1))
    say("ss2024_moladan_court_2c")
	coroutine.yield(getLevel():ZoomBack(1))

    -- Round 1 (real answer needs to be forced out)
    say("ss2024_moladan_court_3")
    local answer = 1
    local text = ""
    repeat
        if answer == 1 then
            text = "ss2024_moladan_court_1_wrong_1"
        elseif answer == 2 then
            text = "ss2024_moladan_court_1_wrong_1a"
        elseif answer == 3 then
            text = "ss2024_moladan_court_1_right"
        end
        local response = text .. "_SAY"

        local result = choice("ss2024_moladan_court_1_wrong_2", text, "ss2024_moladan_court_1_wrong_3")
        if result == 1 then
            say("ss2024_moladan_court_1_wrong_2_SAY")
        elseif result == 2 then 
            say(response)
            answer = answer + 1
        elseif result == 3 then 
            say("ss2024_moladan_court_1_wrong_3_SAY")
        end
    until answer > 3

    -- Round 2 (normal)
    normal_choice("ss2024_moladan_court_2_wrong_1", "ss2024_moladan_court_2_wrong_2", "ss2024_moladan_court_2_right", "ss2024_moladan_court_2_wrong_3")

    -- Round 3 (normal)
    say("ss2024_moladan_court_3_question")
    normal_choice("ss2024_moladan_court_3_wrong_1", "ss2024_moladan_court_3_right", "ss2024_moladan_court_3_wrong_2", "ss2024_moladan_court_3_wrong_3")    

    -- Round 4 (doesn't actually say any of the answers)
    say("ss2024_moladan_court_4_question")
    local uselessResult = choice("ss2024_moladan_court_4_wrong_1", "ss2024_moladan_court_4_wrong_2", "ss2024_moladan_court_4_wrong_3", "ss2024_moladan_court_4_wrong_4")

    -- Round 5 (normal)
    say("ss2024_moladan_court_5_question")
    normal_choice("ss2024_moladan_court_5_wrong_1", "ss2024_moladan_court_5_wrong_2", "ss2024_moladan_court_5_wrong_3", "ss2024_moladan_court_5_wrong_4")


    say("ss2024_moladan_court_6")
end

function onEnd()
  getLevel():resetZoom()
  if badeline then
    badeline:RemoveSelf()
    badeline = nil
  end
  enableMovement()
  setFlag("moladan_court_run", true)
end



--local function badeline_appears(left_side)
--  -- determine the position and flipping properties
--  local pos_x, scale
--  if left_side then
--    pos_x = player.Position.X - 18
--    scale = 1
--  else
--    pos_x = player.Position.X + 18
--    scale = -1
--  end
--  local pos_y = player.Position.Y - 8
--
--  -- create and add a new badeline dummy entity
--  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
--  badeline.Sprite.Scale = vector2(scale, 1.0)
--  getLevel():Add(badeline)
--
--  -- play sound + effect
--  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
--  playSound("event:/char/badeline/maddy_split", badeline.Position)
--
--  -- wait until the next frame so all that can take effect properly
--  wait()
--end
--
--local function badeline_vanishes()
--  -- tell the badeline entity to disappear
--  badeline:Vanish()
--  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
--  -- clear the stored variable so the memory can be used for something else
--  badeline = nil
--
--  -- wait until the next frame
--  wait()
--end
--
--function badelinePopsIn(dialogKey)
--    badeline_appears(true)
--    say(dialogKey)
--    badeline_vanishes()
--end
