local vector2 = require("#microsoft.xna.framework.vector2")

local function fromRoom(x,y)
    return engine.Scene.LevelOffset + vector2(x, y)
end

local function faceTo(npc, x)
  npc:SetHorizontalScale(x)
end

function onBegin()
  if not getFlag("passedEye") then
    setFlag("passedEye", true)
    disableMovement()
    coroutine.yield(getLevel():ZoomTo(vector2(174, 136), 2.3, 2))
    say("SS2024_Donker19_TheEyeDialog01")
    for _, entity in ipairs(getEntities("CrumbleWallOnRumble")) do
      entity:Break()
    end
    coroutine.yield(getLevel():ZoomBack(0.2))
    enableMovement()
  end
end

function onEnd(level, wasSkipped)
  if wasSkipped then
    setFlag("passedEye", true)
    for _, entity in ipairs(getEntities("CrumbleWallOnRumble")) do
      entity:Break()
    end
    enableMovement()
    coroutine.yield(getLevel():ZoomBack(0))
  end
end