local vector2 = require("#microsoft.xna.framework.vector2")

local function fromRoom(x,y)
    return engine.Scene.LevelOffset + vector2(x, y)
end

local function faceTo(npc, x)
  npc:SetHorizontalScale(x)
end

local coroutineEntity = monocle.Entity()

local jeremyNPC = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("jeremy")
local williamNPC = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("william")

function onBegin()
  disableMovement()
  player.Depth = 1000
  player.ForceCameraUpdate = true
  waitUntilOnGround()
  coroutine.yield(getLevel():ZoomTo(vector2(154, 136), 2.3, 1))
  jeremyNPC.Depth = 100
  williamNPC.Depth = 100
  jeremyNPC:PlayAnimation("walk")
  coroutine.yield(jeremyNPC:MoveTo(fromRoom(136,768)))
  jeremyNPC:PlayAnimation("idle")
  wait(0.2)
  say("SS2024_Donker19_BfDialog04")
  faceTo(jeremyNPC, -1)
  jeremyNPC:PlayAnimation("run")

  getLevel():add(coroutineEntity)
  williamNPC:PlayAnimation("panic")
  coroutineEntity:add(monocle.Coroutine(jeremyNPC:MoveTo(fromRoom(40,768))))
  coroutineEntity:add(monocle.Coroutine(say("SS2024_Donker19_BfDialog04A")))

  player.Depth = 0
  coroutine.yield(getLevel():ZoomBack(1))
  enableMovement()
end

function onEnd(level, wasSkipped)
  getLevel():remove(coroutineEntity)
  if wasSkipped then
    enableMovement()
    williamNPC:PlayAnimation("panic_end")
    player.Depth = 0
    jeremyNPC.Depth = 1000000
    getLevel():remove(coroutineEntity)
    coroutine.yield(getLevel():ZoomBack(0))
  end
end