local vector2 = require("#microsoft.xna.framework.vector2")

local function fromRoom(x,y)
    return engine.Scene.LevelOffset + vector2(x, y)
end

local function faceTo(npc, x)
  npc:SetHorizontalScale(x)
end

local barrier

local jeremyNPC

function onBegin()
  disableMovement()
  barrier = celeste.InvisibleBarrier(fromRoom(323, 0), 8, 184)
  engine.Scene:add(barrier)
  player.ForceCameraUpdate = true
  waitUntilOnGround()
  coroutine.yield(getLevel():ZoomTo(vector2(154, 136), 2.3, 1))
  jeremyNPC = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("jeremy")
  jeremyNPC.Depth = 100
  player.Depth = 1000
  jeremyNPC:PlayAnimation("walk")
  coroutine.yield(jeremyNPC:MoveTo(fromRoom(376,152)))
  jeremyNPC:PlayAnimation("idle")
  wait(0.2)
  say("SS2024_Donker19_BfDialog02")
  wait(0.2)
  faceTo(jeremyNPC, -1)
  jeremyNPC:PlayAnimation("walk")
  coroutine.yield(jeremyNPC:MoveTo(fromRoom(328,152)))
  player.Depth = 0
  coroutine.yield(getLevel():ZoomBack(1))
  barrier:RemoveSelf()
  enableMovement()
end

function onEnd(level, wasSkipped)
  if wasSkipped then
    enableMovement()
    if barrier then
      engine.Scene:remove(barrier)
    end
    player.Depth = 0
    jeremyNPC.Depth = 1000000
    coroutine.yield(getLevel():ZoomBack(0))
  end
end