local vector2 = require("#Microsoft.Xna.Framework.Vector2")

local spotlight = require("#Celeste.SpotlightWipe")
local screenwipe = require("#Celeste.ScreenWipe")

function onBegin()

  disableMovement()
  waitUntilOnGround()

  player.DummyAutoAnimate = false
  player.Sprite:Play("runWind", true)
  walkTo(10224, false, 0.75)

  setFlag("crush1", true)
  wait(0.2)
  setFlag("crush2", true)
  wait(0.25)
  setFlag("crush3", true)
  wait(0.6)
  setFlag("crush4", true)
  wait(1)
  shake(0.2)
  
  spotlight.FocusPoint = player.Position - getRoom().Camera.Position
  local wipe = spotlight(getRoom(), false)
  wipe.Duration = 2
  wait(wipe.Duration)
  setFlag("black", true)
  teleportTo(10600,-2536, "b-00-door")
  endCutscene()
    
end

function onEnd(room, wasSkipped)

  if wasSkipped then
    setFlag("black", true)
    teleportTo(10600,-2536, "b-00-door")
  end
  
  enableMovement()
  
end