local vector2 = require("#Microsoft.Xna.Framework.Vector2")

local lua_helper = require("#celeste.mod.LuaCutscenes.LuaHelper")
local monocle = require("#monocle")

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function summonEvie(position)
  evie = celeste.NPC(position)
  getRoom():Add(evie)
  local sprite = celeste.GFX.SpriteBank:Create("evie")
  evie:Add(sprite)
  evie.Sprite = sprite
  sprite:Play("idle")
  evie.IdleAnim = "idle"
  evie.MoveAnim = "runWind"
  evie.Maxspeed = 46
  evie.MoveY = true
end

local function moveEvie(xVector, yVector)
  coroutine.yield(evie:MoveTo(evie.Position + vector2(xVector, yVector)))
end

local function evieWalks()
  moveEvie(220, 0)
end
local walkCoroutine

function onBegin()
  
  disableMovement()
  waitUntilOnGround()

  player.DummyAutoAnimate = false
  player.Sprite:Play("runWind", true)
  walkTo(10124, false, 0.5)

  player.DummyAutoAnimate = true
  summonEvie(vector2(9876, -2544))
  if getFlag("evie_spokento") then
    say("SS2024_QTPI_COLLAPSE_A")
  else
    say("SS2024_QTPI_COLLAPSE_A_ALT")
  end
  player.Facing = getEnum("Celeste.Facings", "Left")

  walkCoroutine = makeCoroutine(evieWalks)
  cutsceneEntity:Add(walkCoroutine)
  coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(9872, -2682), 2))
  wait(0.5)
  setFlag("crush1", true)
  wait(0.2)
  setFlag("crush2", true)
  wait(0.25)
  setFlag("crush3", true)
  wait(0.6)
  setFlag("crush4", true)
  wait(0.35)
  walk(-24, false, 1)
  shake(0.2)
  
  player.DummyAutoAnimate = false
  player.Sprite:Play("skid", false)
  wait(0.05)
  player.Facing = getEnum("Celeste.Facings", "Left")
  setFlag("black", true)
  teleportTo(10456,-2528, "b-00-door")
  
end

function onEnd(room, wasSkipped)

  if wasSkipped then
    player.Facing = getEnum("Celeste.Facings", "Left")
    setFlag("black", true)
    teleportTo(10456,-2528, "b-00-door")
  end
  
  enableMovement()
  
  
  if walkCoroutine then
    walkCoroutine:Cancel()
    cutsceneEntity:Remove(walkCoroutine)
    walkCoroutine = nil
  end
end