local math = require("math")
local audio = require("#Celeste.Audio")

local function firstNode()
     for i = 1, 4, 1 do
        beam({
            angle = 0 + i*i*15
        },
        {
            angle = 45 + i*i*15
        },
        {
            angle = 90 + i*i*15
        },
        {
            angle = 180 + i*i*15
        },
        {
            angle = 270 + i*i*15
        },
        {
            angle = 315 + i*i*15
        })
        wait(0.00001)
    end
    for i=1,30 do
		shoot({
			waveStrength = 10,
			speed = 100,
		})
		wait(0.6)
	end
	wait(0.7)
end

local function secondNode()
    beginCharge()
    wait(0.1)
    while true do
        for i = 1, 4, 1 do
            if player then
                local at = player.Center
                shootAt(at, {waveStrength = -30, speed = 50})
                wait(0.3)
                shootAt(at, {waveStrength = 30, speed = 100})
                wait(0.3)
            end
            if i < 4 then
                beginCharge()
                wait(0.5)
                beginCharge()
                wait(0.15)

                shoot({
                    angleOffset = 30,
                })
                shoot({
                    angleOffset = -30,
                })
                shoot({
                    waveStrength = 12,
                })
            end
        end
        wait(1)
        beginCharge()
        wait(0.7)
    end
end

local function thirdNode()
    for i = 1, 4, 1 do
        beam({
            angle = 0 - i*15
        },
        {
            angle = 45 + i*15
        },
        {
            angle = 90 - i*15
        },
        {
            angle = 135 + i*15
        },
        {
            angle = 180 - i*15
        },
        {
            angle = 270 + i*15
        },
        {
            angle = 315 - i*15
        },
        {
            angle = 360 - i*15
        })
        beam({
            followTime = 0.5,
            rotationSpeed = 2000,
        })
        wait(0.00001)
    end
end

local function forthNode()
    while true do
        for i = 1, 60, 1 do
            shoot({
                angle = 90 + i*20, 
                waveStrength = 20,
			    speed = 75
            })
            wait(0.05)
        end
        wait(4)
    end

end


local function sixNode()
    while true do
        for i = 1, 10, 1 do
            if player then
                local at = player.Center
                shootAt(at, {waveStrength = -30, speed = 50})
                wait(0.05)
                shootAt(at, {waveStrength = -30, speed = 50})
                wait(0.15)
                shootAt(at, {waveStrength = -30, speed = 50})
                wait(0.05)
                shootAt(at, {waveStrength = -30, speed = 50})
                beam({
                    angle = 0 
                },
                {
                    angle = 45 
                },
                {
                    angle = 90 
                },
                {
                    angle = 135
                },
                {
                    angle = 180 
                },
                {
                    angle = 270
                },
                {
                    angle = 315 
                })
                wait(0.7)
            end
        end
        wait(2)
    end

end

local function fiveNode()
    while true do
        large = 0
        for i = 1, 130, 1 do
        
            b = math.random(1,4)
            a = math.random(0,30)

            if large == 1 or large == 2 or lage == 3 then

                large = large + 1

            end

            if large == 0 then

                if b == 4 then
            
                    large = 0
            
                end

                if b == 1 or b == 2 then 

                    large = large + 1

                end

            end

            if large == 0 or large == 3 then 
            shoot({
                angle = -90 + a + 4*i*large,
                waveStrength = 10,
			    speed = 200,
                large = 0
            })
            end
            
            wait(0.01)
        end
        beam({
            followTime = 0.5,
            rotationSpeed = 2000
        })
        beam({
            followTime = 0.5,
            rotationSpeed = 2000
        })
    end

end

local function sevenNode()
    while true do
        for i = 1, 5, 1 do
            
            beginCharge()
                wait(0.15)

                shoot({
                    angleOffset = 30, waveStrength = 10,
                })
                shoot({
                    angleOffset = -30, waveStrength = 10,
                })
                shoot({
                    waveStrength = 10,
                })
                wait(0.15)
                shoot({
                    angleOffset = 30, waveStrength = 20,
                })
                shoot({
                    angleOffset = -30, waveStrength = 20,
                })
                shoot({
                    waveStrength = 10,
                })
                beginCharge()
                wait(0.15)

                shoot({
                    angleOffset = 30 + 90, waveStrength = 10,
                })
                shoot({
                    angleOffset = -30  + 90, waveStrength = 10,
                })
                shoot({
                    waveStrength = 10,
                })
                wait(0.05)
                shoot({
                    angleOffset = 30 + 90, waveStrength = 20,
                })
                shoot({
                    angleOffset = -30 + 90, waveStrength = 20,
                })
                shoot({
                    waveStrength = 10,
                })

                beam({
                followTime = math.random(1,3)/30,
                rotationSpeed = 8000,
                    })
                beam({
                    angle = math.random(90,180)
                    })
                wait(0.5)
            
        end
        wait(1)
    end

end

local function eightNode()
    while true do
        for i = 1, 30, 1 do
            shoot({
                angle = 90 - 45*i ,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i -15 - i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i + 15 + i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i + 30 + i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i - 30 - i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            wait(0.05)
        end
        wait(4)
    end

end

local function nineNode()
    while true do
        for i = 1, 30, 1 do
            shoot({
                angle = 90 - 45*i ,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i -15 - i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i + 15 + i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i + 30 + i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            shoot({
                angle = 90 - 45*i - 30 - i,
                waveStrength = 4*math.sqrt(i),
			    speed = 100
            })
            wait(0.05)
        end
        wait(4)
    end

end

local function zeroNode()
        wait(2)


end


local function tenNode()
    while true do
        for i = 1,30, 1 do
            shoot({
                angle = i*20 + math.random(-15,15),
                waveStrength = 5 - i/2 ,
			    speed = 70 + i/2
            })
            shoot({
                angle = 180 + i*20 + math.random(-15,15),
                waveStrength = 10 - i/2,
			    speed = 70 + i/2
            })
            shoot({
                angle = -90 + i*20 + math.random(-15,15),
                waveStrength = 15 - i/2 ,
			    speed = 70 + i/2
            })
            shoot({
                angle = 90 -20 + i*20 + math.random(-15,15),
                waveStrength = 10,
			    speed = 70 + i/2
            })
            wait(0.3)
        end

        for c = 1,8,1 do
            for i = 1,20, 1 do
                shoot({
                angle = 18*i + c*math.random(-25,25),
                waveStrength = 5 + 1.5*c,
			    speed = 100 + c*5
                })
            end
            wait(0.8)
        end

        for i = 1, 6, 1 do
            beam({
                angle = 0 + i*22.5
            },
            {
                angle = 45 + i*22.5
            },
            {
                angle = 90 + i*22.5
            },
            {
                angle = 135 + i*22.5
            },
            {
                angle = 180 + i*22.5
            },
            {
                angle = 270 + i*22.5
            },
            {
                angle = 235 + i*22.5
            },
            {
                angle = 315 + i*22.5
            })
            beam({
                angle = 0 - i*i*11.25
            },
            {
                angle = 45 - i*i*11.25
            },
            {
                angle = 90 - i*i*11.25
            },
            {
                angle = 135 - i*i*11.25
            },
            {
                angle = 180 - i*i*11.25
            },
            {
                angle = 270 - i*i*11.25
            },
            {
                angle = 235 - i*i*11.25
            },
            {
                angle = 315 - i*i*11.25
            })
            beam({
                angle = 0 + i*22.5
            },
            {
                angle = 45 + i*22.5
            },
            {
                angle = 90 + i*22.5
            },
            {
                angle = 135 + i*22.5
            },
            {
                angle = 180 + i*22.5
            },
            {
                angle = 270 + i*22.5
            },
            {
                angle = 235 + i*22.5
            },
            {
                angle = 315 + i*22.5
            },
            {
                angle = 0 - i*i*11.25
            },
            {
                angle = 45 - i*i*11.25
            },
            {
                angle = 90 - i*i*11.25
            },
            {
                angle = 135 - i*i*11.25
            },
            {
                angle = 180 - i*i*11.25
            },
            {
                angle = 270 - i*i*11.25
            },
            {
                angle = 235 - i*i*11.25
            },
            {
                angle = 315 - i*i*11.25
            })
            wait(0.00001)
        end
        wait(0.2)
        wait(3)
        
        
    end

end


-- stores a list of all ai's to use, in order
-- for each node you have in the boss, there should be one more function stored here
local ais = {
    zeroNode, -- Does Nothing
    firstNode, -- lasers
    secondNode, -- one of the most twisted ones
    thirdNode,
    forthNode,
    fiveNode,
    sixNode,
    sevenNode,
    eightNode,
    nineNode,
    tenNode -- evilone-- will be used after the boss gets hit twice
}

function ai()
    local func = ais[nodeIndex + 1]
    while func do
        func()
    end
end