local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local shuffleRoutine
local confettiRoutine
local coroutineEntity = monocle.Entity()

local violebula
local astrixie
local galaska
local rupulsar

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end


local function dash(xVector,yVector)
	player.OverrideDashDirection = vector2(0, -1)
	setPlayerState(2)
	wait(0.6)
	setPlayerState(11)
	player.OverrideDashDirection = nil
end

local function escape()
	wait(0.2)
	getLevel():add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(jump()))
	coroutineEntity:add(monocle.Coroutine(wait(0.1)))
	coroutineEntity:add(monocle.Coroutine(dash(0,-1)))
end


function onBegin()
	setFlag("elevatorMusicStarted", false)
	violebula = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("violebula")
	astrixie = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("astrixie")
	galaska = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("galaska")
	galaska:SetHorizontalScale(-1)
	rupulsar = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("rupulsar")
	rupulsar:SetHorizontalScale(-1)
	player.ForceCameraUpdate = true
	disableMovement()
	getLevel():add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 124), 3, 2)))	
	walkTo(2200)
	player.Facing = getEnum("Celeste.Facings", "Right")	
	say("SecretSanta2024_3_Hard_bryse0n_btransition")
	violebula.Position = vector2(player.Position.X - 78, player.Position.Y - 16)
	astrixie.Position = vector2(player.Position.X - 62, player.Position.Y - 16)
	player.ForceCameraUpdate = false
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(getLevel().Camera.Position.X - 28, getLevel().Camera.Position.Y), 2))
	player.Facing = getEnum("Celeste.Facings", "Left")		
	say("SecretSanta2024_3_Hard_bryse0n_btransition2")
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(getLevel().Camera.Position.X - 32, getLevel().Camera.Position.Y), 2))
	wait(1)
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(getLevel().Camera.Position.X + 32, getLevel().Camera.Position.Y), 2))
	say("SecretSanta2024_3_Hard_bryse0n_btransition3")
	galaska.Position = vector2(player.Position.X + 78, player.Position.Y - 16)
	rupulsar.Position = vector2(player.Position.X + 62, player.Position.Y - 16)
	coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(getLevel().Camera.Position.X + 28, getLevel().Camera.Position.Y), 1)))
	coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 108), 2, 2)))
	say("SecretSanta2024_3_Hard_bryse0n_btransition4")
	player.Facing = getEnum("Celeste.Facings", "Right")
	say("SecretSanta2024_3_Hard_bryse0n_btransition5")
	player.Facing = getEnum("Celeste.Facings", "Left")
	coroutine.yield(astrixie:MoveTo(vector2(player.Position.X - 48, astrixie.Y)))
	say("SecretSanta2024_3_Hard_bryse0n_btransition6")
	player.ForceCameraUpdate = true
	escape()
	playMusic("event:/bryse0n/tonychewisdead")
	setFlag("elevatorMusicStarted", true)
	coroutine.yield(getLevel():ZoomBack(3))
	wait(3.8)
	say("SecretSanta2024_3_Hard_bryse0n_btransition7")
end


function onEnd(room, wasSkipped)
	if wasSkipped then
		getLevel():ResetZoom()
		astrixie.Position = vector2(0,0)
		violebula.Position = vector2(0,0)
		galaska.Position = vector2(0,0)
		rupulsar.Position = vector2(0,0)
		setFlag("removeblue", true)
		setFlag("addplanets", true)
		instantTeleportTo(2199, -11698)
	end
	if not getFlag("elevatorMusicStarted") then
		playMusic("event:/bryse0n/tonychewisdead")
	end
	getLevel():ResetZoom()
	enableMovement()
	enableRetry()
end