 local flagTable = {}

 -- fill out the table with every room - replace "room1", "room2", etc with every room name
 local function fillTable()
  if not getFlag("tableFilled") then
    flagTable[1] = "c - 50 50 100"
    flagTable[2] = "c - Take Flight"
    flagTable[3] = "c - Butcher's Phanto Pit"
    flagTable[4] = "c - Citrea's Barrier to Entry"
    flagTable[5] = "c - The Fall of our Keys"
    flagTable[6] = "c - On the Up and Up"
    flagTable[7] = "c - As Bugs Bunny Always Says"
    setFlag("tableFilled", true)
  end
end

-- remove a room from the list of possible rooms
local function roomBeaten(tableIndex)
  if flagTable[tableIndex] ~= nil and flagTable[tableIndex] ~= "done" then
    flagTable[tableIndex] = "done"
  end
end

-- pick a new room to send the player to
local function getNextRoom()
  -- check if the player died, and update the death count if so
  if getFlag("roomDeath") then
    if getFlag("9death") then
      -- If the player has run out of lives, return them to the start
      return "c - Beginning of the End"
    end
    if getFlag("8death") then
      setFlag("9death", true)
    end
    if getFlag("7death") then
      setFlag("8death", true)
    end
    if getFlag("6death") then
      setFlag("7death", true)
    end
    if getFlag("5death") then
      setFlag("6death", true)
    end
    if getFlag("4death") then
      setFlag("5death", true)
    end
    if getFlag("3death") then
      setFlag("4death", true)
    end
    if getFlag("2death") then
      setFlag("3death", true)
    end
    if getFlag("1death") then
      setFlag("2death", true)
    end
    if getFlag("0death") then
      setFlag("1death", true)
    end
  end
  -- If all rooms havew been beaten, return the exit room
  local allRoomsBeaten = true
  for i=1,#flagTable do
    if flagTable[i] ~= nil and flagTable[i] ~= "done" then
      allRoomsBeaten = false
    end
  end
  if allRoomsBeaten then
    return "c - The Mysterious Tree"
  end

  -- check if this is the last room, and if so return the current room
  if getFlag("SixFlag") and getFlag("roomDeath") then
    return getLevel().Session.LevelData.Name
  end

  local nextRoom = math.random(1, #flagTable)
  -- reroll if the room has already been beaten, or is the current room
  while flagTable[nextRoom] == "done" or flagTable[nextRoom] == getLevel().Session.LevelData.Name do
      nextRoom = math.random(1, #flagTable)
  end
  -- -- return the room name
  return flagTable[nextRoom]
end

function onBegin()
   -- if this is the first time running, fill out the flag table
  if not getFlag("tableFilled") then
    fillTable()
    setFlag("tableFilled", true)
  end

  -- check if a flag corresponding to a room name has been set - if it has, that means the room has been beaten, and it can be removed from the table. for this to work, at the end of every room you need to set a save data flag named the same as the room itself. you need to reset all these flags at the start of the map
  for i=1,#flagTable do
    if getFlag(flagTable[i]) then
      roomBeaten(i)
    end
  end
  -- now we need to get the name of the next room we're sending the player to. this is why naming the flags the same as the rooms was important
  local nextRoomName = getNextRoom()
  changeRoom(nextRoomName)
end

function onTalk()
  -- stops the player from being able to move mid-teleport
  disableMovement()

  -- Screen wipe for transition
  getLevel():DoScreenWipe(false)
  wait(.5)
  
  -- Update the room counter
  if getFlag("FiveFlag") then
    setFlag("SixFlag", true)
    setFlag("FiveFlag", false)
  end
  if getFlag("FourFlag") then
    setFlag("FiveFlag", true)
    setFlag("FourFlag", false)
  end
  if getFlag("ThreeFlag") then
    setFlag("FourFlag", true)
    setFlag("ThreeFlag", false)
  end
  if getFlag("TwoFlag") then
    setFlag("ThreeFlag", true)
    setFlag("TwoFlag", false)
  end
  if getFlag("OneFlag") then
    setFlag("TwoFlag", true)
    setFlag("OneFlag", false)
  end
  if getFlag("ZeroFlag") then
    setFlag("OneFlag", true)
    setFlag("ZeroFlag", false)
  end
  if getFlag("StartCount") then
    setFlag("ZeroFlag", true)
    setFlag("StartCount", false)
  end

  --give the player another life if this isn't the very first door
  local lifeGained = true
  if getFlag("notFirst") then
    if getFlag("9death") and lifeGained then
      setFlag("9death", false)
      lifeGained = false
    end
    if getFlag("8death") and lifeGained then
      setFlag("8death", false)
      lifeGained = false
    end
    if getFlag("7death") and lifeGained then
      setFlag("7death", false)
      lifeGained = false
    end
    if getFlag("6death") and lifeGained then
      setFlag("6death", false)
      lifeGained = false
    end
    if getFlag("5death") and lifeGained then
      setFlag("5death", false)
      lifeGained = false
    end
    if getFlag("4death") and lifeGained then
      setFlag("4death", false)
      lifeGained = false
    end
    if getFlag("3death") and lifeGained then
      setFlag("3death", false)
      lifeGained = false
    end
    if getFlag("2death") and lifeGained then
      setFlag("2death", false)
      lifeGained = false
    end
    if getFlag("1death") and lifeGained then
      setFlag("1death", false)
      done = false
    end
  end

  -- if this is the first time running, fill out the flag table
 if not getFlag("tableFilled") then
   fillTable()
   setFlag("tableFilled", true)
 end

 -- check if a flag corresponding to a room name has been set - if it has, that means the room has been beaten, and it can be removed from the table. for this to work, at the end of every room you need to set a save data flag named the same as the room itself. you need to reset all these flags at the start of the map
 for i=1,#flagTable do
  if getFlag(flagTable[i]) then
    roomBeaten(i)
  end
end

 -- now we need to get the name of the next room we're sending the player to. this is why naming the flags the same as the rooms was important
 local nextRoomName = getNextRoom()

--The player has 
 setFlag("notFirst", true)

  -- teleport the player
 changeRoom(nextRoomName)

end