local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local goodToGo = false
local waitingCoroutine
local coroutineEntity = monocle.Entity()

local function waitTilCameraMoved()
	wait(4)
	goodToGo = true
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
	if not getFlag("f4trans-done") then
		setFlag("f4-trans5", true)
		setFlag("wcActivate2", false)
		getLevel():add(coroutineEntity)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(5744, -92), 0)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(120, 130), 2, 0)))
		wait(1.0)
		setFlag("f4-black", false)
		wait(0.5)
		playSound("event:/game/06_reflection/fall_spike_smash")
		setFlag("wcActivate1", false)
		setFlag("wcActivate2", true)
		setFlag("wcActivate3", true)
		wait(4)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(6527, -728), 3)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomBack(3)))	
		waitingCoroutine = makeCoroutine(waitTilCameraMoved)
		cutsceneEntity:Add(waitingCoroutine)
		while not goodToGo do
			wait()
		end
		waitingCoroutine:Cancel()
		cutsceneEntity:Remove(waitingCoroutine)
		say("SSC3_Gamation_Flag4_ending3")
	end
end

function onEnd()
	--if waitingCoroutine = not nil then
		--waitingCoroutine:Cancel()
		--cutsceneEntity:Remove(waitingCoroutine)
		--waitingCoroutine = nil
	--end
	if not getFlag("f4trans-done") then
		getLevel():remove(coroutineEntity)
		enableMovement()
		enableRetry()
		setFlag("f4trans-done", true)
	end
end
	