local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local coroutineEntity = monocle.Entity()
local goodToGo = false
local waitingCoroutine

local function waitTilCameraMoved()
	wait(5)
	goodToGo = true
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
	if not getFlag("f4trans-done") then
		player.Facing = getEnum("Celeste.Facings", "Left") -- face left
		setFlag("f4-black", false)
		setFlag("f4-trans1", false)
		setFlag("wcActivate1", false)
		setFlag("wcActivate2", false)
		setFlag("wcActivate3", false)
		disableMovement()
		say("SSC3_Gamation_Flag4_ending1")
		playSound("event:/char/badeline/appear")
		say("SSC3_Gamation_Flag4_ending1_2")
		wait(1)
		
		getLevel():add(coroutineEntity)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(5744, -92), 5)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(120, 120), 1.5, 5)))
		waitingCoroutine = makeCoroutine(waitTilCameraMoved)
		cutsceneEntity:Add(waitingCoroutine)
		say("SSC3_Gamation_Flag4_ending2")
		while not goodToGo do
			wait()
		end
		goodToGo = false
		waitingCoroutine:Cancel()
		cutsceneEntity:Remove(waitingCoroutine)
		getLevel().Displacement:AddBurst(vector2(5858, 48), 0.5, 8, 64, 1)
		setFlag("wcActivate1", true)
		playSound("event:/game/04_cliffside/arrowblock_activate")
		wait(0.5)
		--teleportTo(6052, 285, "f4-trans1")
		if not getFlag("photosensitive") then
			setFlag("f4-black", true)
			setFlag("f4-trans1", true)
			return nil
		end
		wait(1.5)
		playSound("event:/game/06_reflection/fall_spike_smash")
		setFlag("wcActivate1", false)
		setFlag("wcActivate2", true)
		setFlag("wcActivate3", true)
		wait(4)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(6527, -728), 3)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomBack(3)))
		wait(3)
		say("SSC3_Gamation_Flag4_ending3")
	end
end

function onEnd()
	if not getFlag("f4-black") then
		if not getFlag("f4trans-done") then
		--if not getFlag("photosensitive") then
			--setFlag("f4-black", true)
			--setFlag("f4-trans1", true)
		--else
			getLevel():ResetZoom()
			enableMovement()
			setFlag("f4trans-done", true)
		--end
		end
	end
end