local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function dash(xVector,yVector)
 player.OverrideDashDirection = vector2(xVector, yVector)
 helpers.setPlayerState (2)
 helpers.wait(0.6)
 helpers.setPlayerState (11)
 player.OverrideDashDirection = nil
end

local function jumpAttack()
	wait(0.2)
	setFlag("intermission-attack", true)
	getLevel():add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(jump()))
	coroutineEntity:add(monocle.Coroutine(wait(0.05)))
	coroutineEntity:add(monocle.Coroutine(dash(1,0)))	
end

function onBegin()
	setFlag("f2-attack", false)
	waitUntilOnGround()
	disableMovement()
	walkTo(11617)
	local luanet = _G.luanet
	player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
	coroutine.yield(getLevel():ZoomTo(vector2(240, 50), 2, 1))
	say("SSC3_Gamation_Flag2_ending")
	makeUnskippable()
	setFlag("f2-attack", true)
	jumpAttack()
end

function onEnd()
	player.OverrideDashDirection = nil
	enableMovement()
	if not getFlag("f2-attack") then
		setFlag("f2EndingSkipped", true)
	end
end