local math = require("math")
local string = require("string")
local os = require("os")

local function rollRoom()
	local currentRoom = getLevel().Session.LevelData.Name
	local trimmedRoom = string.sub(currentRoom, -4, string.len(currentRoom))
	math.randomseed(getLevel().Session.Time)
	local nextRoom = "g-0" .. math.random(1,4)
	while nextRoom == trimmedRoom do
		nextRoom = "g-0" .. math.random(1,4)
		wait()
	end
	return nextRoom
end

--- Instantly teleport the player seamlessly BUT BETTER.
--  Teleport player to (x, y) position, in pixels WITHOUT EXPLODING PORTALS.
--   - luna
-- Room name as only argument will seamlessly teleport to that room at the same relative position.
-- @tparam any x X offset on X axis if number. Target room if string.
-- @number y Y offset on Y axis.
-- @string[opt] room What room the game should attempt to load. By default same room.
local function instantTeleportToPlusPlus(x, y, room)
    if x and y then
        Celeste.Mod.QuickAndDirtyDebrisLimiter.QuickAndDirtyDebrisLimiterModule.InstantTeleportPlusPlus(getLevel(), player, room or "", false, x, y)
    else
        Celeste.Mod.QuickAndDirtyDebrisLimiter.QuickAndDirtyDebrisLimiterModule.InstantTeleportPlusPlus(getLevel(), player, x or "", true, 0.0, 0.0)
    end
end

--- Instantly teleport the player to the same coordinates in another room seamlessly.
-- Teleport player (x, y) pixels from current position.
-- Room name as only argument will seamlessly teleport to that room at the same relative position.
-- @tparam any x X offset on X axis if number. Target room if string.
-- @number y Y offset on Y axis.
-- @string[opt] room What room the game should attempt to load. By default same room.
local function instantTeleportPlusPlus(x, y, room)
    if x and y then
        instantTeleportToPlusPlus(player.Position.X + x, player.Position.Y + y, room)
    else
        instantTeleportToPlusPlus(x, y, room)
    end
end

function onBegin()
	if not getFlag("photosensitive") then
		makeUnskippable()
		celeste.Glitch.Value = 1
		playSound("event:/new_content/game/10_farewell/glitch_short")
		local roomToTP = rollRoom()
		--local roomToTP = "g-0" .. math.random(1,4)
		local waitTime = (math.random() * 4) + 2.95
		wait(0.05)
		celeste.Glitch.Value = 0
		wait(waitTime)
		if not getFlag("f1MainDone") then
			instantTeleportPlusPlus(roomToTP)
		end
	end
end
