local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()
local marioNPC
local breathingMinigame

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function dash(xVector,yVector)
	OverrideDashDirection = vector2(xVector, yVector)
	setPlayerState(2)
	wait(0.6)
	setPlayerState(11)
	OverrideDashDirection = nil
end

function onBegin()
	player.OverrideDashDirection = nil
	disableMovement()
	disableRetry()
	player.DummyAutoAnimate = false
	player.Sprite:Play("idle")
	marioNPC = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("mario")
	marioNPC:PlayAnimation("hidden")
	say("SSC3_Gamation_Flag1")
	coroutine.yield(getLevel():ZoomTo(vector2(120, 120), 1.5, 2))
	say("SSC3_Gamation_Flag1_2")
	coroutine.yield(getLevel():ZoomAcross(vector2(120, 120), 2, 2))
	player.Sprite:Play("tired")
	say("SSC3_Gamation_Flag1_3")
	coroutine.yield(getLevel():ZoomAcross(vector2(120, 120), 2.5, 1))
	say("SSC3_Gamation_Flag1_4")
	wait(1)
	setFlag("f1-intro-crumble", true)
	wait(0.5)
	marioNPC:PlayAnimation("idle")
	setFlag("f1-intro-mario-emerge", true)
	playSound("event:/SS2024_Gamation_marioPipeIn")
	marioNPC:PlayAnimation("runSlow")
	coroutine.yield(marioNPC:MoveTo(vector2(player.Position.X + 16, marioNPC.Y)))
	marioNPC:PlayAnimation("idle")
	wait(0.5)
	say("SSC3_Gamation_Flag1_5")
	say("SSC3_Gamation_Flag1_6")
	makeUnskippable()
	breathingMinigame = celeste.BreathingMinigame(true, nil)
	getLevel():Add(breathingMinigame)
	while not breathingMinigame.Completed do
		wait()
	end
	player.Sprite:Play("idle")
	say("SSC3_Gamation_Flag1_7")
	coroutine.yield(getLevel():ZoomBack(3))
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		marioNPC = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("mario")
		marioNPC:PlayAnimation("idle")
		marioNPC.X = player.Position.X + 16
		setFlag("f1-intro-crumble", true)
	end
	getLevel():ResetZoom()
	enableMovement()
	enableRetry()
	player.DummyAutoAnimate = true
end