local math = require("math")
local os = require("os")

--- Instantly teleport the player seamlessly BUT BETTER.
--  Teleport player to (x, y) position, in pixels WITHOUT EXPLODING PORTALS.
--   - luna
-- Room name as only argument will seamlessly teleport to that room at the same relative position.
-- @tparam any x X offset on X axis if number. Target room if string.
-- @number y Y offset on Y axis.
-- @string[opt] room What room the game should attempt to load. By default same room.
local function instantTeleportToPlusPlus(x, y, room)
    if x and y then
        Celeste.Mod.QuickAndDirtyDebrisLimiter.QuickAndDirtyDebrisLimiterModule.InstantTeleportPlusPlus(getLevel(), player, room or "", false, x, y)
    else
        Celeste.Mod.QuickAndDirtyDebrisLimiter.QuickAndDirtyDebrisLimiterModule.InstantTeleportPlusPlus(getLevel(), player, x or "", true, 0.0, 0.0)
    end
end

--- Instantly teleport the player to the same coordinates in another room seamlessly.
-- Teleport player (x, y) pixels from current position.
-- Room name as only argument will seamlessly teleport to that room at the same relative position.
-- @tparam any x X offset on X axis if number. Target room if string.
-- @number y Y offset on Y axis.
-- @string[opt] room What room the game should attempt to load. By default same room.
local function instantTeleportPlusPlus(x, y, room)
    if x and y then
        instantTeleportToPlusPlus(player.Position.X + x, player.Position.Y + y, room)
    else
        instantTeleportToPlusPlus(x, y, room)
    end
end

function onBegin()
	makeUnskippable()
	instantTeleportPlusPlus("g-01")
end
