local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")
local luaReflection = loadCelesteAsset("Assets/SS2024/Gamation/luaReflection")

local catTheoBoss = getFirstEntity("FrostHelper.Entities.LuaBadelineBoss", "")
local dashUpCoroutine
local coroutineEntity = monocle.Entity()

local function dash()
	player.OverrideDashDirection = vector2(0, -1)
	setPlayerState(2)
	wait(0.6)
	setPlayerState(11)
	player.OverrideDashDirection = nil
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end


function onBegin()
	disableMovement()
	waitUntilOnGround()
	catTheoBoss.Sprite:Play("idle")
	setFlag("f1_blackScreen", false)
	walkTo(16800)
	player.Sprite:Play("lookUp")
	coroutine.yield(getLevel():ZoomTo(vector2(160, 90), 1.5, 1))
	say("SSC3_Gamation_Final_6")
	
	dashUpCoroutine = makeCoroutine(dash)
	cutsceneEntity:Add(dashUpCoroutine)
	while player.Position.Y > -1160 do
		wait()
	end
    	--coroutine.yield(luaReflection.callCoroutine(catTheoBoss, "MoveSequence", { player, false }))
	getLevel().Displacement:AddBurst(catTheoBoss.Center, 0.5, 8, 64, 1)
	celeste.Glitch.Value = 0.5
	getLevel():Remove(catTheoBoss)
	setFlag("theoGone", true)
	playSound("event:/char/badeline/boss_hug")
	celeste.Audio.SetMusicParam("fade", 0.0)
	wait(0.05)
	celeste.Glitch.Value = 0
	wait(2)
	coroutine.yield(getLevel():ZoomBack(4))
	wait(1)
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(getLevel().Camera.Position.X, -1173), 2.5))
	setFlag("fightDoneExit", true)
	wait(2.5)
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(getLevel().Camera.Position.X, -1235), 1.5))
	player.OverrideDashDirection = nil
end

function onEnd()
	enableMovement()
	getLevel():ResetZoom()
	setFlag("fightDoneExit", true)
	if not getFlag("theoGone") then
		getLevel():Remove(catTheoBoss)
	end
end