local offset = 0
local shotgunOffset = 225
local doneBeamHell1 = false
local doneBeamHell2 = false
local arcTimesShot = 0
local math = require("math")
local audio = require("#Celeste.Audio")

local function waitPattern()
	wait()
end

local function octShootPattern()
	shoot({
            angle = 0 + offset,
        })
        shoot({
            angle = 45 + offset,
        })
        shoot({
            angle = 90 + offset,
        })
        shoot({
            angle = 135 + offset,
        })
        shoot({
            angle = 180 + offset,
        })
        shoot({
            angle = 225 + offset,
        })
        shoot({
            angle = 270 + offset,
        })
        shoot({
            angle = 315 + offset,
        })
        wait(0.75)
        offset = offset + 22.5
end

local function quickBeamPattern()
        beam({
            followTime = 0.3,
            lockTime = 0.2,
            rotationSpeed = 300,
        })
end

local function shootBeamPattern()	
	shoot({
            angle = 0 + offset,
        })
        shoot({
            angle = 90 + offset,
        })
        shoot({
            angle = 180 + offset,
        })
        shoot({
            angle = 270 + offset,
        })
        offset = offset + 45
        beam({
            followTime = 0.35,
            lockTime = 0.18,
            rotationSpeed = 400,
        })
	wait(0.18)
end

local function quickfirePattern()
	for i=1,22 do
		shoot({
			waveStrength = 1.5
		})
		wait(0.02)
	end
	wait(1.05)
end

local function quickfireHardPattern()
	for i=1,30 do
		shoot({
			waveStrength = 1.5,
			speed=150,
		})
		wait(0.02)
	end
	wait(0.8)
end

local function quickfireHardestPattern()
	for i=1,30 do
		shoot({
			waveStrength = 1.5,
			speed = 200,
		})
		wait(0.02)
	end
	wait(0.7)
end

local function quickfireBeamPattern()
        beam({
            followTime = 0.12,
            lockTime = 0.16,
            rotationSpeed = 10000,
        })	
end

local function shotgunBlastPattern()
	for i=0,9 do
		shoot({
            		angle = (10 * i) + shotgunOffset
        	})
	end
	wait(0.7)
	shotgunOffset = shotgunOffset - 90
end

local function doubleShotgunBlastPattern()
	for i=0,9 do
		shoot({
            		angle = (10 * i) + shotgunOffset
        	})
		shoot({
            		angle = (10 * i) + shotgunOffset + 180
        	})
	end
	wait(0.8)
	shotgunOffset = shotgunOffset - 90
end

local function arcHorzFlippedPattern()
	local arcAngleMod
	if arcTimesShot % 2 == 0 then
		arcAngleMod = 0
	else
		arcAngleMod = -45
	end
	for i=6,14,1 do
		shoot({
            		angle = (5 * i) + arcAngleMod + 90,
			speed = 70,
        	})
		wait(0.05)
	end
	wait(1)
	arcTimesShot = arcTimesShot + 1
end


local function arcPattern()
	local arcAngleMod
	if arcTimesShot % 2 == 0 then
		arcAngleMod = 0
	else
		arcAngleMod = -45
	end
	for i=6,14,1 do
		shoot({
            		angle = (5 * i) + arcAngleMod,
			speed = 70,
        	})
		wait(0.05)
	end
	wait(1)
	arcTimesShot = arcTimesShot + 1
end

local function pacmanHellPattern()
	local safeAreas = {}
	safeAreas[1] = 90
	safeAreas[2] = 180
	safeAreas[3] = 0
	--math.randomseed = getLevel().Session.Time
	local safeQuad = safeAreas[math.random(1,3)]
	if not doneBeamHell2 then
		for counter=1,25 do
			for i=-15,300,10 do
				shoot({
            				angle = i + safeQuad,
					speed = 20,
        			})
			end
			wait(0.25)
		end
		doneBeamHell2 = true
	else
		beam({
            		followTime = 0.6,
            		lockTime = 0.5,
            		rotationSpeed = 300,
        	})
	end
end

local function pacmanHellBeamPattern()
	local safeAreas = {}
	safeAreas[1] = 90
	safeAreas[2] = 180
	safeAreas[3] = 0
	--math.randomseed = getLevel().Session.Time
	local safeQuad = safeAreas[math.random(1,3)]
	if not doneBeamHell1 then
		for counter=1,25 do
			for i=0,270,10 do
				shoot({
            				angle = i + safeQuad,
					speed = 15,
        			})
			end
			wait(0.25)
			if counter > 10 then
				beam({
            				followTime = 0.3,
            				lockTime = 0.25,
            				rotationSpeed = 400,
        			})
			end
		end
		doneBeamHell1 = true
	else 			
		beam({
            	followTime = 0.8,
            	lockTime = 0.8,
            	rotationSpeed = 300,
        	})
	end
end

-- unused, looks bad, doesn't work
local function spinHellPattern()

	for i=0,360,10 do
		for bullets=1,15 do
			shoot({
				angle = i,
				speed = math.random(100,200)
        		})
			wait(0.02)
		end
		wait(0.25)
	end
	wait(100000000)
end


local ais = {
	waitPattern, -- 0
	octShootPattern, -- 1
	quickBeamPattern, -- 2
	shootBeamPattern, -- 3
	shootBeamPattern, -- 4
	quickfirePattern, -- 5
	quickfireHardPattern, -- 6
	quickfireHardestPattern, -- 7
	quickfireBeamPattern, -- 8
	quickfireBeamPattern, -- 9
	arcHorzFlippedPattern, -- 10
	shotgunBlastPattern, -- 11
	doubleShotgunBlastPattern, -- 12
	arcPattern, -- 13
	pacmanHellPattern, -- 14
	pacmanHellBeamPattern, -- 15
	waitPattern, -- 16
	waitPattern, -- 17
	waitPattern, -- 18
	waitPattern, -- 19
	waitPattern, -- 20
	waitPattern -- 21, out of bounds
}

function ai()
	local func = ais[nodeIndex + 1]
	while true do
		func()
	end
end

function onHit()
	if nodeIndex == 1 then
		audio.SetMusicParam("fade", 1)
	end
	if nodeIndex == 12 then
		shotgunOffset = 225
	end
	if nodeIndex == 16 then
		setFlag("fightEndingDialogue", true)
		audio.SetMusicParam("fade", 0.8)
	end
	if nodeIndex == 17 then
		audio.SetMusicParam("fade", 0.75)
	end
	if nodeIndex == 18 then
		setFlag("fightEndingDialogue2", true)
		audio.SetMusicParam("fade", 0.7)
	end
	if nodeIndex == 19 then
		setFlag("audio40", false)
		audio.SetMusicParam("fade", 0.6)
	end
	if nodeIndex == 20 then
		setFlag("fightDone", true)
		audio.SetMusicParam("fade", 0.5)
	end
end