local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function dash(xVector,yVector)
	OverrideDashDirection = vector2(xVector, yVector)
	setPlayerState(2)
	wait(0.6)
	setPlayerState(11)
	OverrideDashDirection = nil
end

local function jumpAttack()
	wait(0.2)
	setFlag("intermission-attack", true)
	getLevel():add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(jump()))
	coroutineEntity:add(monocle.Coroutine(wait(0.05)))
	coroutineEntity:add(monocle.Coroutine(dash(1,0)))
end

function onBegin()
	celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("catTheo"):PlayAnimation("idle")
	setFlag("intermission-attack", false)
	disableMovement()
	makeUnskippable()
	getLevel():add(coroutineEntity)
	coroutine.yield(getLevel():ZoomTo(vector2(198, 108), 1.75, 0.5))
	say("SSC3_Gamation_Intermission_3")
	dialogueChoice = helpers.choice("SSC3_Gamation_Intermission_GIVEUP_SMALL","SSC3_Gamation_Intermission_GO_SMALL")
	if dialogueChoice == 1 or dialogueChoice == "SSC3_Gamation_Intermission_GIVEUP_SMALL" then
		say("SSC3_Gamation_Intermission_GIVEUP")
		setFlag("intermission-fadeout", true)
		wait(1.5)
		walk(40, false, 0.2)
		say("SSC3_Gamation_Intermission_GIVEUP_2")
		getLevel():CompleteArea()
	else 
		say("SSC3_Gamation_Intermission_GO")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(198, 116), 2.25, 1)))
		coroutineEntity:add(monocle.Coroutine(wait(2)))
		say("SSC3_Gamation_Intermission_GO_2")
		jumpAttack()
	end	
end

function onEnd()
	if getFlag("intermission-fadeout") then
		setFlag("intermission-endmap", true)
	else
		enableMovement()
	end
end