local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()
local teleportWaitingCoroutine

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function dash(xVector,yVector)
	OverrideDashDirection = vector2(xVector, yVector)
	setPlayerState(2)
	wait(0.6)
	setPlayerState(11)
	OverrideDashDirection = nil
end

local function teleportOut()

end

local function jumpAttack()
	wait(0.2)
	setFlag("intermission-attack", true)
	getLevel():add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(jump()))
	coroutineEntity:add(monocle.Coroutine(wait(0.05)))
	coroutineEntity:add(monocle.Coroutine(dash(1,0)))
end

function onBegin()
	celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("catTheo"):PlayAnimation("idle")
	setFlag("jumpToEnding", false)
	setFlag("intermission-attack", false)
	disableMovement()
	walkTo(8226)
	local luanet = _G.luanet
	player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
	say("SSC3_Gamation_Intermission")
	getLevel():add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(198, 108), 1.75, 3)))
	say("SSC3_Gamation_Intermission_2")
	wait(2.0)
	setFlag("endingInitiated", true)
	makeUnskippable()
	disableRetry()
	say("SSC3_Gamation_Intermission_3")
	dialogueChoice = helpers.choice("SSC3_Gamation_Intermission_GIVEUP_SMALL","SSC3_Gamation_Intermission_GO_SMALL")
	if dialogueChoice == 1 or dialogueChoice == "SSC3_Gamation_Intermission_GIVEUP_SMALL"  then
		say("SSC3_Gamation_Intermission_GIVEUP")
		setFlag("intermission-fadeout", true)
		wait(1.5)
		walk(40, false, 0.2)
		say("SSC3_Gamation_Intermission_GIVEUP_2")
		getLevel():CompleteArea()
	else 
		say("SSC3_Gamation_Intermission_GO")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(198, 116), 2.25, 1)))
		coroutineEntity:add(monocle.Coroutine(wait(2)))
		say("SSC3_Gamation_Intermission_GO_2")
		jumpAttack()
	end	
end

function onEnd()
	if getFlag("endingInitiated") then
		if getFlag("intermission-fadeout") then
			setFlag("intermission-endmap", true)
		else
			enableMovement()
		end
	else
		setFlag("jumpToEnding", true)
	end
end