local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
	if not getFlag("valhallaWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = false
		disableMovement()

		theo = celeste.NPC(player.Position)
		level:Add(theo)
		local sprite = celeste.GFX.SpriteBank:Create("theo")
		theo:Add(sprite)
		theo.Sprite = sprite
		theo.Maxspeed = 55

		level:ZoomSnap(vector2(160, 100), 1.5)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(9712, -1152), 0.1)))
		wait(0.5)
		setFlag("rocket-end", false)
		sprite:Play("walk", false, false)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(player.Position.X + 90, theo.Y))))
		wait(1.8)
		sprite:Play("idle", false, false)
		wait(1.5)
		say("SSC2024_fonda_valhalla02")
		walk(70)
		wait(1.0)
		say("SSC2024_fonda_valhalla03")
		wait(0.7)
		sprite:Play("walk", false, false)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(theo.X + 15, theo.Y))))
		wait(0.5)
		sprite:Play("idle", false, false)
		say("SSC2024_fonda_valhalla04")
		walk(20)
		say("SSC2024_fonda_valhalla05")
		wait(0.2)
		sprite.Scale = vector2(-1,1)
		wait(0.2)
		say("SSC2024_fonda_valhalla06")
		wait(1.0)
		say("SSC2024_fonda_valhalla07")
		coroutine.yield(level:ZoomBack(2.0))
		setFlag("valhallaWatched", true)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		player.Position = vector2(9848,-1016)
		theo.Position = vector2(0,0)
		player.Facing = getEnum("Celeste.Facings", "Right")
		setFlag("theoflag", true)
		setFlag("rocket-end", false)
		setFlag("valhallaWatched", true)
		enableMovement()
    end
end