local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local goodToGo = false
local waitingCoroutine
local coroutineEntity = monocle.Entity()

local function waitTilDialog()
	say("SSC2024_fonda_theocall07")
	goodToGo = true
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
	if not getFlag("theocall1Watched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		theo = celeste.NPC(player.Position + vector2(26, -32))
        level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 40

		level:ZoomSnap(vector2(160, 115), 1.6)
		setFlag("white", false)
		wait(0.7)
		sprite:Play("walk", false, false)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(theo.X + 48, theo.Y))))
		wait(0.2)
		waitingCoroutine = makeCoroutine(waitTilDialog)
		cutsceneEntity:Add(waitingCoroutine)
		wait(0.9)
		sprite:Play("idle", false, false)
		wait(1.1)
		theo.Maxspeed = 30
		sprite:Play("walk", false, false)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(theo.X - 36, theo.Y))))
		wait(1.3)
		sprite:Play("idle", false, false)
		wait(0.8)
		sprite.Scale = vector2(1,1)
		while not goodToGo do
			wait()
		end
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 115), 2.1, 3.0)))
		wait(0.7)
		sprite:Play("think", false, false)
		wait(0.3)
		say("SSC2024_fonda_theocall08")
		wait(1.5)
		say("SSC2024_fonda_theocall05")
		wait(0.2)
		sprite.Scale = vector2(-1,1)
		sprite:Play("takeSelfie", false, false)
		playSound("event:/game/02_old_site/theoselfie_foley", player.Position)
		wait(1.0)
		setFlag("white", true)
		wait(0.3)
		setFlag("teleporting", true)
		wait(20.0)
		playSound("event:/moladan/radio", player.Position)
		wait(1.0)
		playSound("event:/game/01_forsaken_city/console_static_long", player.Position)
		say("SSC2024_fonda_theocall01")
		coroutine.yield(getLevel():ZoomTo(vector2(160, 70), 1.5, 2.0))
		say("SSC2024_fonda_theocall02")
		walk(-15)
		say("SSC2024_fonda_theocall03")
		walk(20)
		say("SSC2024_fonda_theocall04")
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		wait(0.2)
		setFlag("white", true)
		wait(0.4)
		setFlag("theocall2", true)
		setFlag("teleporting", true)
		wait(20)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("theocall1Watched", true)
		setFlag("theocall2Watched", true)
		enableMovement()
		setFlag("teleporting", true)
    end
end