local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
	if not getFlag("salemWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = false
		disableMovement()
		
		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 40

		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(110, 90), 1.5, 2.0)))
		walkTo(15730, false, 0.7)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(1.0)

		theo = celeste.NPC(player.Position - vector2(70, 0))
        level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 65

		sprite:Play("run", false, false)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(player.Position.X - 20, theo.Y))))
		wait(1.0)
		sprite:Play("tired", false, false)
		wait(0.5)
		say("SSC2024_fonda_salem01")
		sprite:Play("idle", false, false)
		walk(70)
		say("SSC2024_fonda_salem02")
		sprite:Play("walk", false, false)
		coroutine.yield(theo:MoveTo(vector2(player.Position.X - 20, theo.Y)))
		sprite:Play("idle", false, false)
		say("SSC2024_fonda_salem03")

		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(15890, -2756), 3)))
		wait(3.7)
		say("SSC2024_fonda_salem04")
		wait(0.5)
		player.Position = vector2(15870, player.Position.Y + 8)
		theo.Position = player.Position
		sprite:Play("walk", false, false)
		player.DummyAutoAnimate = false
		player.Sprite:Play("walk")
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(player.Position.X + 95, false, 1.0)))
		wait(0.3)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(theo.X + 70, theo.Y))))
		wait(1.3)
		sprite:Play("idle", false, false)
		wait(0.8)
		say("SSC2024_fonda_salem05")
		salem:SetHorizontalScale(-1)
		wait(0.3)
		playMusic("event:/moladan/OMORI OST - 056 I Think My Dad Shops Here")
		say("SSC2024_fonda_salem06")
		wait(0.2)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.2)
		say("SSC2024_fonda_salem07")
		wait(0.2)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.2)
		say("SSC2024_fonda_salem08")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(110, 100), 2.3, 3.0)))
		wait(1.0)
		say("SSC2024_fonda_salem09")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(110, 90), 1.5, 2.0)))
		wait(2.0)
		say("SSC2024_fonda_salem10")

		setFlag("rocket-end", true)
		wait(2.4)
		salem.Position = vector2(player.Position.X, player.Position.Y + 300)
		setFlag("rocket-end", false)
		wait(2.0)
		say("SSC2024_fonda_salem11")
		wait(0.2)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.2)
		say("SSC2024_fonda_salem12")
		wait(0.2)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.2)
		say("SSC2024_fonda_salem13")
		setFlag("rocket-end", true)
		wait(2.5)
		setFlag("teleporting", true)
		wait(40.0)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("rocket-end", false)
		setFlag("salemWatched", true)
		setFlag("teleportingskip", true)
		enableMovement()
    end
end