local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()
local sfxSoundSource = celeste.SoundSource()

function onBegin()
	if not getFlag("panicWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 65), 2.0, 3.0)))
		wait(0.5)
		walk(16)
		wait(0.1)
		walk(-16)
		wait(0.1)
		walk(10)
		wait(0.1)
		walk(-20)
		wait(0.1)
		walk(18)
		wait(0.3)
		player.DummyAutoAnimate = false
		player.Sprite:Play("tired", true)
		wait(0.5)
		say("SSC2024_fonda_panic01")
		wait(0.5)
		playSound("event:/moladan/radio", player.Position)
		wait(1.0)
		playSound("event:/game/01_forsaken_city/console_static_long", player.Position)
		sfxSoundSource:Play("event:/game/01_forsaken_city/console_static_loop")
		say("SSC2024_fonda_panic02")
		player.DummyAutoAnimate = true
		player.Sprite:Play("idle", true)
		wait(0.3)
		walk(-16)
		say("SSC2024_fonda_panic03")
		wait(1.5)
		walk(16)
		wait(0.5)
		say("SSC2024_fonda_panic04")
		sfxSoundSource:Stop()
		coroutine.yield(level:ZoomBack(2.0))
		setFlag("panicWatched", true)
		setFlag("panicCrumble", true)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		sfxSoundSource:Stop()
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("panicWatched", true)
		setFlag("panicCrumble", true)
		enableMovement()
    end
end