local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()
local sfxSoundSource = celeste.SoundSource()

function onBegin()
	if not getFlag("noteWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 70), 1.5, 2.0)))
		walk(45, false, 0.7)
		wait(0.5)
		say("SSC2024_fonda_note01")
		wait(0.5)
		player.DummyAutoAnimate = false
		player.Sprite:Play("duck", true)
		wait(0.5)
		playSound("event:/char/theo/resort_standtocrawl", player.Position)
		wait(0.5)
		player.Sprite:Play("idle", true)
		player.DummyAutoAnimate = true
		wait(0.5)
		say("SSC2024_fonda_note02")
		wait(0.3)
		setFlag("note", true)
		playSound("event:/game/03_resort/memo_in", player.Position)
		wait(1.0)

		local Talked = false
		while not Talked do
			if celeste.Input.MenuConfirm.Check then
				Talked = true
			else
				wait()
			end
		end

		setFlag("noteMove", true)
		playSound("event:/game/03_resort/memo_out", player.Position)
		wait(2.0)
		say("SSC2024_fonda_note03")
		walk(-20)
		say("SSC2024_fonda_note04")
		wait(0.5)
		playSound("event:/moladan/radio", player.Position)
		wait(1.0)
		playSound("event:/game/01_forsaken_city/console_static_long", player.Position)
		sfxSoundSource:Play("event:/game/01_forsaken_city/console_static_loop")
		say("SSC2024_fonda_note05")
		sfxSoundSource:Stop()
		walk(15)
		coroutine.yield(level:ZoomBack(2.0))
		setFlag("noteWatched", true)
		setFlag("note", false)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		sfxSoundSource:Stop()
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("noteWatched", true)
		setFlag("note", false)
		enableMovement()
    end
end