local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

local spotlight = require("#Celeste.SpotlightWipe")
local screenwipe = require("#Celeste.ScreenWipe")

function onBegin()
	if not getFlag("morning6Watched") then
		makeUnskippable()
		disableRetry()
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()
		
		setFlag("smoke", true)
		coroutine.yield(getLevel():ZoomTo(vector2(160, 83), 2.5, 3.1))
		setFlag("textbox", true)
		wait(3.1)
		coroutine.yield(level:ZoomBack(0.4))
		wait(0.8)
		playSound("event:/moladan/rocketliftoff", player.Position)
		playSound("event:/moladan/rocketflyfade", player.Position)
		setFlag("rocket", true)
		wait(29.0)
		setFlag("rocket-end", true)
		wait(4.0)
		say("SSC2024_fonda_morning11")
		wait(1.0)
		setFlag("teleporting", true)
		--setFlag("morning4Watched", true)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("teleportingskip", true)
		setFlag("morningWatched", true)
		enableMovement()
    end
end