local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

local spotlight = require("#Celeste.SpotlightWipe")
local screenwipe = require("#Celeste.ScreenWipe")

function onBegin()
	if not getFlag("morning3Watched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		enableMovement()
		disableMovement()
		
		theo = celeste.NPC(player.Position + vector2(135, 0))
        level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 45
		sprite.Scale = vector2(-1,1)
		
		level:ZoomSnap(vector2(160, 95), 2.5)
		wait(1.0)
		setFlag("rocket-end", false)
		coroutine.yield(level:ZoomBack(3.0))
		walk(105)
		wait(1.0)
		say("SSC2024_fonda_morning08")
		coroutine.yield(getLevel():ZoomTo(vector2(160, 95), 1.5, 2.0))
		say("SSC2024_fonda_morning09")
		makeUnskippable()
		disableRetry()
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 95), 2.0, 0.5)))
		playSound("event:/game/05_mirror_temple/button_activate", player.Position)
		playSound("event:/game/03_resort/clutterswitch_finish", player.Position)
		playSound("event:/game/01_forsaken_city/console_red", player.Position)
		playSound("event:/moladan/Ignition", player.Position)
		playSound("event:/moladan/rocketstartfade", player.Position)
		setFlag("red", true)
		wait(0.1)
		setFlag("red", false)
		wait(4.5)
		setFlag("teleporting", true)
		--setFlag("morning4Watched", true)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("teleportingskip", true)
		setFlag("morningWatched", true)
		enableMovement()
    end
end